/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.List;
import javax.swing.Box;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerListModel;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.robotframework.swing.testapp.ContentChangingCombobox;
import org.robotframework.swing.testapp.PopupPanel;
import org.robotframework.swing.testapp.TestButton;
import org.robotframework.swing.testapp.TestCheckBox;
import org.robotframework.swing.testapp.TestComboBox;
import org.robotframework.swing.testapp.TestDesktopPane;
import org.robotframework.swing.testapp.TestEditorPane;
import org.robotframework.swing.testapp.TestFileChooser;
import org.robotframework.swing.testapp.TestLabel;
import org.robotframework.swing.testapp.TestList;
import org.robotframework.swing.testapp.TestMenuBar;
import org.robotframework.swing.testapp.TestRadioButton;
import org.robotframework.swing.testapp.TestSpinnerButton;
import org.robotframework.swing.testapp.TestTabbedPane;
import org.robotframework.swing.testapp.TestTable;
import org.robotframework.swing.testapp.TestTextArea;
import org.robotframework.swing.testapp.TestTextField;
import org.robotframework.swing.testapp.TestToggleButton;
import org.robotframework.swing.testapp.TestTree;
import org.robotframework.swing.testapp.TreeWithoutTreeNode;

public class TestApplication {
    private JPanel panel;
    private JFrame frame;

    public static void main(String[] args) {
        new TestApplication().runTestApplication();
    }

    public void runTestApplication() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TestApplication.this.createFrame();
                TestApplication.this.createMainPanel();
                TestApplication.this.addMenuBar();
                TestApplication.this.addComponentsToMainPanel();
                TestApplication.this.addMainPanelToFrame();
                TestApplication.this.showGUI();
            }
        });
    }

    private void showGUI() {
        this.frame.pack();
        this.frame.setVisible(true);
    }

    private void addMainPanelToFrame() {
        Container contentPane = this.frame.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.panel, "Center");
        contentPane.add((Component)TestDesktopPane.INSTANCE, "North");
    }

    private void createMainPanel() {
        this.panel = new PopupPanel();
        this.panel.setName("Main Panel");
        FlowLayout flowLayout = new FlowLayout();
        flowLayout.setAlignment(1);
        this.panel.setLayout(flowLayout);
    }

    private void addMenuBar() {
        this.frame.setJMenuBar(new TestMenuBar());
    }

    private void createFrame() {
        this.frame = new JFrame("Test App"){

            public Dimension getPreferredSize() {
                return new Dimension(1000, 1000);
            }
        };
        this.frame.setName("Main Frame");
        this.frame.setDefaultCloseOperation(3);
    }

    private void addComponentsToMainPanel() {
        this.panel.add(new TestTextField());
        this.panel.add(new TestButton());
        this.panel.add(new TestList());
        this.panel.add(new TestList(){
            {
                this.setName("listWithRenderer");
                this.setCellRenderer(new DefaultListCellRenderer(){

                    public String getText() {
                        return super.getText().toUpperCase();
                    }
                });
            }
        });
        this.panel.add(new TestCheckBox("Test Checkbox"));
        this.panel.add(new TestCheckBox("Test Checkbox 2"));
        this.panel.add(new TestCheckBox("Test Checkbox 3"));
        this.panel.add(new TestCheckBox("Test Checkbox 4"));
        this.panel.add(new TestComboBox());
        this.panel.add(new TestComboBox(){
            {
                this.setName("comboboxWithRenderer");
                this.setRenderer(new DefaultListCellRenderer(){

                    public String getText() {
                        return super.getText().toUpperCase();
                    }
                });
            }
        });
        final ContentChangingCombobox contentChangingComboBox = new ContentChangingCombobox();
        this.panel.add(new JButton("Reset Content Changing Combobox"){
            {
                super(x0);
                this.setName("resetContentChangingComboBox");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        contentChangingComboBox.resetModel();
                    }
                });
            }
        });
        this.panel.add(contentChangingComboBox);
        this.panel.add(new TestComboBox(){
            {
                this.setName("disabledComboBox");
                this.setEnabled(false);
            }
        });
        this.panel.add(new TestLabel());
        JTextField tableEventTextField = new JTextField("tableEventTextField");
        tableEventTextField.setName("tableEventTextField");
        tableEventTextField.setText("tableEventTextField");
        this.panel.add(new TestTable("testTable", this.getTestTableData(), tableEventTextField));
        this.panel.add(new TestTable("TableWithSingleValue", this.getFoobarTestTableData(), tableEventTextField));
        this.panel.add(new TestTree());
        this.panel.add(new TreeWithoutTreeNode());
        TestTextField tabButtonOutputTextField = new TestTextField();
        tabButtonOutputTextField.setName("tabButtonOutputTextField");
        this.panel.add(new TestTabbedPane("testTabbedPane1", tabButtonOutputTextField));
        this.panel.add(new TestTabbedPane("testTabbedPane2", tabButtonOutputTextField));
        this.panel.add(tabButtonOutputTextField);
        this.panel.add(new TestTextArea());
        this.panel.add(new TestRadioButton());
        this.panel.add(new TestToggleButton());
        this.panel.add(new JButton("Open File Chooser"){
            {
                this.setName("openFileChooser");
                this.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent e) {
                        new TestFileChooser().showSaveDialog(TestApplication.this.panel);
                    }
                });
            }
        });
        this.panel.add(new TestEditorPane());
        this.panel.add(this.simpleTable());
        this.panel.add(tableEventTextField);
        this.panel.add(new JTextField(){
            {
                this.setName("disabledTextField");
                this.setEnabled(false);
                this.setPreferredSize(new Dimension(100, 30));
            }
        });
        this.panel.add(new JTextField(){
            {
                this.setName("uneditableTextField");
                this.setEditable(false);
                this.setPreferredSize(new Dimension(100, 30));
            }
        });
        this.panel.add(new TestSpinnerButton("testSpinner"));
        List<String> weekDays = Arrays.asList("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday");
        this.panel.add(new TestSpinnerButton("stringSpinner", new SpinnerListModel(weekDays)));
        this.panel.add(new TestSpinnerButton("floatSpinner", new SpinnerNumberModel(77.7, 0.0, 1000.0, 0.1)));
        this.panel.add(this.testSlider());
        this.panel.add(this.tableWithHeader());
    }

    private Component tableWithHeader() {
        JTable tableWithHeader = new JTable(1, 2);
        tableWithHeader.setName("tableWithHeader");
        JTableHeader tableHeader = tableWithHeader.getTableHeader();
        tableHeader.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JTable table = ((JTableHeader)evt.getSource()).getTable();
                TableColumnModel colModel = table.getColumnModel();
                int index = colModel.getColumnIndexAtX(evt.getX());
                table.setValueAt("Col header " + index, 0, 0);
            }
        });
        Box box = Box.createVerticalBox();
        box.add(tableHeader);
        box.add(tableWithHeader);
        return box;
    }

    private JSlider testSlider() {
        JSlider slider = new JSlider(0, 5);
        slider.setName("testSlider");
        slider.setMajorTickSpacing(1);
        slider.setPaintTicks(true);
        return slider;
    }

    private Object[][] getTestTableData() {
        Object[][] data = new Object[][]{{"column one", "one/one", "two/one", "three/one", "four/one"}, {"column two", "one/two", "two/two", "three/two", "four/two"}, {"column three", "one/three", "two/three", "three/three", "four/three"}, {"column four", Boolean.TRUE, Boolean.TRUE, Boolean.FALSE, Boolean.FALSE}};
        return data;
    }

    private Object[][] getFoobarTestTableData() {
        Object[][] data = new Object[][]{{"column one", "foo", "bar", "bar", "bar"}, {"column two", "bar", "foo", "bar", "bar"}, {"column three", "bar", "bar", "foo", "bar"}, {"column four", "bar", "bar", "bar", "foo"}};
        return data;
    }

    private JTable simpleTable() {
        Object[] colNames = new String[]{"first col", "second col"};
        Object[][] data = new Object[][]{{"fooness", "barness"}, {"quuxness", "lochness"}};
        JTable table = new JTable(data, colNames){

            public boolean isCellEditable(int row, int column) {
                return column != 1;
            }
        };
        table.setName("simpleTable");
        table.setCellSelectionEnabled(true);
        return table;
    }
}

