/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.robotframework.javalib.util.KeywordNameNormalizer;
import org.robotframework.swing.testapp.Delay;
import org.robotframework.swing.testapp.TestTreeResults;

public class TestTree
extends JTree
implements ActionListener {
    private static final String ROOT_NAME = "The Java Series";
    private String rootName = "The Java Series";
    private final ActionCommand insertChild = new ActionCommand(){

        protected void operate() {
            this.getLastPathComponent().add(new DefaultMutableTreeNode("child"));
        }
    };
    private final ActionCommand removeSelected = new ActionCommand(){

        protected void operate() {
            TreePath[] selectionPaths;
            for (TreePath treePath : selectionPaths = TestTree.this.getSelectionPaths()) {
                ((DefaultMutableTreeNode)treePath.getLastPathComponent()).removeFromParent();
            }
        }
    };
    private final ActionCommand showMessage = new ActionCommand(){

        protected void operate() {
            JOptionPane.showMessageDialog(TestTree.this, "This is an example message");
        }
    };
    private final ActionCommand hideRoot = new ActionCommand(){

        protected void operate() {
            TestTree.this.setRootVisible(false);
        }
    };
    private final ActionCommand showRoot = new ActionCommand(){

        protected void operate() {
            TestTree.this.setRootVisible(true);
        }
    };
    private final ActionCommand saveNodes = new ActionCommand(){

        protected void operate() {
            TestTreeResults.saveNodes(TestTree.this.getSelectionPaths());
        }
    };
    private final ActionCommand removeRootName = new ActionCommand(){

        protected void operate() {
            TestTree.this.rootName = "";
        }
    };
    private final ActionCommand restoreRootName = new ActionCommand(){

        protected void operate() {
            TestTree.this.rootName = TestTree.ROOT_NAME;
        }
    };

    public TestTree() {
        this(new MyTreeNode(ROOT_NAME){
            {
                this.add(new DefaultMutableTreeNode("Books for Java Programmers"){
                    {
                        this.add(new MyTreeNode("The Java Tutorial: A Short Course on the Basics"));
                        this.add(new MyTreeNode("The Java Tutorial Continued: The Rest of the JDK"));
                        this.add(new MyTreeNode("The JFC Swing Tutorial: A Guide to Constructing GUIs"));
                    }
                });
                this.add(new MyTreeNode("Books for Java Implementers"){
                    {
                        this.add(new MyTreeNode("The Java Virtual Machine Specification"){
                            {
                                this.add(new MyTreeNode("leafnode1"));
                                this.add(new MyTreeNode("leafnode2"));
                            }
                        });
                        this.add(new MyTreeNode("The Java Language Specification"){
                            {
                                this.add(new MyTreeNode("leafnode3"));
                                this.add(new MyTreeNode("leafnode4"));
                            }
                        });
                    }
                });
            }
        });
    }

    public TestTree(DefaultMutableTreeNode dmtn) {
        super(dmtn);
        this.setName("testTree");
        this.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    new MyPopup().show((JComponent)e.getSource(), e.getX(), e.getY());
                }
            }

            public void mouseClicked(MouseEvent e) {
                TestTreeResults.saveNodes(TestTree.this.getSelectionPaths());
                TestTreeResults.clickCount = e.getClickCount();
            }
        });
        this.setCellRenderer(new DefaultTreeCellRenderer(){

            public String getText() {
                String nodeText = super.getText();
                if (nodeText.equals(TestTree.ROOT_NAME)) {
                    return TestTree.this.rootName.toLowerCase();
                }
                return nodeText.toLowerCase();
            }
        });
    }

    public void actionPerformed(ActionEvent ae) {
        this.createActionCommand(ae.getActionCommand()).perform();
    }

    private ActionCommand createActionCommand(String command) {
        if (command.equals("insert")) {
            return this.insertChild;
        }
        if (command.equals("remove")) {
            return this.removeSelected;
        }
        if (command.equals("showdialog")) {
            return this.showMessage;
        }
        if (command.equals("hideroot")) {
            return this.hideRoot;
        }
        if (command.equals("showroot")) {
            return this.showRoot;
        }
        if (command.equals("savenodes")) {
            return this.saveNodes;
        }
        if (command.equals("removerootname")) {
            return this.removeRootName;
        }
        if (command.equals("restorerootname")) {
            return this.restoreRootName;
        }
        return new ActionCommand(){

            protected void operate() {
            }
        };
    }

    private static class MyTreeNode
    extends DefaultMutableTreeNode {
        public MyTreeNode(final String txt) {
            super(new Object(){

                public String toString() {
                    return txt;
                }
            });
            Delay.delay();
        }
    }

    private class MyPopup
    extends JPopupMenu {
        public MyPopup() {
            this.add(new MenuItemWithCommand("Insert a child", "insert"));
            this.add(new MenuItemWithCommand("Remove", "remove"));
            this.add(new MenuItemWithCommand("Save node paths", "savenodes"));
            this.add(new MenuItemWithCommand("Show dialog", "showdialog"));
            this.add(new MenuItemWithCommand("Hide root node", "hideroot"));
            this.add(new MenuItemWithCommand("Show root node", "showroot"));
            this.add(new MenuItemWithCommand("Remove root name", "removerootname"));
            this.add(new MenuItemWithCommand("Restore root name", "restorerootname"));
            this.add(new JMenuItem("Disabled menuitem"){
                {
                    super(x0);
                    this.setEnabled(false);
                }
            });
            this.add(new JMenu("Submenu"){
                {
                    super(x0);
                    this.add(new JMenuItem("Disabled menuitem"){
                        {
                            this.setEnabled(false);
                        }
                    });
                    this.add(new JMenuItem("Enabled menuitem"));
                }
            });
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
            this.setName("popupMenu");
        }

        public void show(Component invoker, int x, int y) {
            Delay.delay();
            super.show(invoker, x, y);
        }
    }

    private class MenuItemWithCommand
    extends JMenuItem {
        public MenuItemWithCommand(String text, String actionCommand) {
            super(text);
            this.setName(new KeywordNameNormalizer().normalize(text));
            this.setActionCommand(actionCommand);
            this.addActionListener(TestTree.this);
            Delay.delay();
        }
    }

    private abstract class ActionCommand {
        private ActionCommand() {
        }

        public void perform() {
            Delay.delay();
            this.operate();
            this.refresh();
            TestTree.this.updateUI();
        }

        protected abstract void operate();

        private void refresh() {
            ((DefaultTreeModel)TestTree.this.getModel()).nodeStructureChanged(this.getLastPathComponent());
        }

        protected DefaultMutableTreeNode getLastPathComponent() {
            TreePath selectionPath = TestTree.this.getSelectionPath();
            if (selectionPath == null) {
                return null;
            }
            return (DefaultMutableTreeNode)selectionPath.getLastPathComponent();
        }
    }
}

