/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.textcomponent;

import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;

public class HtmlElement
implements Element {
    private final Element element;

    public HtmlElement(Element element) {
        this.element = element;
    }

    public AttributeSet getAttributes() {
        return this.element.getAttributes();
    }

    public Document getDocument() {
        return this.element.getDocument();
    }

    public Element getElement(int index) {
        return this.element.getElement(index);
    }

    public int getElementCount() {
        return this.element.getElementCount();
    }

    public int getElementIndex(int offset) {
        return this.element.getElementIndex(offset);
    }

    public int getEndOffset() {
        return this.element.getEndOffset();
    }

    public String getName() {
        return this.element.getName();
    }

    public Element getParentElement() {
        return this.element.getParentElement();
    }

    public int getStartOffset() {
        return this.element.getStartOffset();
    }

    public boolean isLeaf() {
        return this.element.isLeaf();
    }

    public String getText() {
        int start = this.getStartOffset();
        int length = this.getEndOffset() - start;
        try {
            return this.getDocument().getText(start, length);
        }
        catch (BadLocationException e1) {
            throw new RuntimeException(e1);
        }
    }

    public HtmlElement getChild(int index) {
        return new HtmlElement(this.getElement(index));
    }

    public URL getUrl() {
        String href = this.getHref();
        URL base = this.getBase();
        return this.createURL(base, href);
    }

    public String getHref() {
        return (String)this.getA().getAttribute(HTML.Attribute.HREF);
    }

    private URL getBase() {
        return ((HTMLDocument)this.getDocument()).getBase();
    }

    private AttributeSet getA() {
        return (AttributeSet)this.getAttributes().getAttribute(HTML.Tag.A);
    }

    URL createURL(URL base, String href) {
        try {
            return new URL(base, href);
        }
        catch (MalformedURLException e) {
            return null;
        }
    }
}

