/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.robotframework.org.netbeans.jemmy.operators.JTreeOperator;
import org.robotframework.swing.tree.TreePathAction;

public class TreeIterator {
    private final JTreeOperator treeOperator;

    public TreeIterator(JTreeOperator treeOperator) {
        this.treeOperator = treeOperator;
    }

    public void operateOnAllNodes(TreePathAction treePathAction) {
        this.doOnAll(this.root(), treePathAction);
    }

    TreePath root() {
        return new TreePath(this.treeOperator.getRoot());
    }

    private void doOnAll(TreePath parent, TreePathAction treePathAction) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Enumeration<? extends TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            TreePath path = parent.pathByAddingChild(e.nextElement());
            this.doOnAll(path, treePathAction);
        }
        treePathAction.operate(parent);
    }
}

