/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.finder.matchers;

import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.robotframework.abbot.finder.Matcher;
import org.robotframework.abbot.util.ExtendedComparator;

public class JMenuItemMatcher
implements Matcher {
    private String label;

    public JMenuItemMatcher(String label) {
        this.label = label;
    }

    public static String getPath(JMenuItem item) {
        Component parent = item.getParent();
        if (parent instanceof JPopupMenu) {
            parent = ((JPopupMenu)parent).getInvoker();
        }
        if (parent instanceof JMenuItem) {
            return JMenuItemMatcher.getPath((JMenuItem)parent) + "|" + item.getText();
        }
        return item.getText();
    }

    public static List splitMenuPath(String path) {
        int lastFoundIndex = -1;
        ArrayList<String> selectionPath = new ArrayList<String>();
        while ((lastFoundIndex = path.indexOf(124, lastFoundIndex)) != -1) {
            selectionPath.add(path.substring(0, lastFoundIndex));
            ++lastFoundIndex;
        }
        selectionPath.add(path);
        return selectionPath;
    }

    public boolean matches(Component c) {
        if (c instanceof JMenuItem) {
            JMenuItem mi = (JMenuItem)c;
            String text = mi.getText();
            return ExtendedComparator.stringsMatch(this.label, text) || ExtendedComparator.stringsMatch(this.label, JMenuItemMatcher.getPath(mi));
        }
        return false;
    }
}

