/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.script;

import java.awt.Component;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.WaitTimedOutError;
import org.robotframework.abbot.finder.ComponentNotFoundException;
import org.robotframework.abbot.finder.ComponentSearchException;
import org.robotframework.abbot.finder.MultipleComponentsFoundException;
import org.robotframework.abbot.i18n.Strings;
import org.robotframework.abbot.script.ComponentReference;
import org.robotframework.abbot.script.NoSuchReferenceException;
import org.robotframework.abbot.script.Resolver;
import org.robotframework.abbot.script.Step;
import org.robotframework.abbot.script.parsers.Parser;
import org.robotframework.abbot.tester.ComponentTester;
import org.robotframework.abbot.util.Condition;

public class ArgumentParser {
    private static final String ESC_ESC_COMMA = "%%2C";
    public static final String ESC_COMMA = "%2c";
    public static final String NULL = "null";
    public static final String DEFAULT_TOSTRING = "<default-tostring>";
    private static Map parsers = new HashMap();
    static /* synthetic */ Class class$abbot$script$parsers$Parser;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$abbot$script$ComponentReference;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$java$lang$String;

    private ArgumentParser() {
    }

    private static boolean isExtension(String name) {
        return name.indexOf(".extensions.") != -1;
    }

    private static Parser findParser(String name, Class targetClass) {
        Log.debug("Trying " + name + " for " + targetClass);
        try {
            Class<?> cvtClass = ArgumentParser.isExtension(name) ? Class.forName(name, true, targetClass.getClassLoader()) : Class.forName(name);
            Parser parser = (Parser)cvtClass.newInstance();
            if (cvtClass.getName().indexOf(".extensions.") == -1) {
                parsers.put(targetClass, parser);
            }
            return parser;
        }
        catch (InstantiationException ie) {
            Log.debug(ie);
        }
        catch (IllegalAccessException iae) {
            Log.debug(iae);
        }
        catch (ClassNotFoundException cnf) {
            Log.debug(cnf);
        }
        return null;
    }

    public static Parser setParser(Class cls, Parser parser) {
        Parser old = (Parser)parsers.get(cls);
        parsers.put(cls, parser);
        return old;
    }

    public static Parser getParser(Class cls) {
        Parser parser = (Parser)parsers.get(cls);
        if (parser == null) {
            String base = ComponentTester.simpleClassName(cls);
            String pkg = (class$abbot$script$parsers$Parser == null ? (class$abbot$script$parsers$Parser = ArgumentParser.class$("org.robotframework.abbot.script.parsers.Parser")) : class$abbot$script$parsers$Parser).getPackage().getName();
            parser = ArgumentParser.findParser(pkg + "." + base + "Parser", cls);
            if (parser == null) {
                parser = ArgumentParser.findParser(pkg + ".extensions." + base + "Parser", cls);
            }
        }
        return parser;
    }

    private static boolean isBounded(String s) {
        return s.startsWith("[") && s.endsWith("]") || s.startsWith("\"") && s.endsWith("\"") || s.startsWith("'") && s.endsWith("'");
    }

    private static String escapeCommas(String s) {
        return ArgumentParser.replace(ArgumentParser.replace(s, ESC_COMMA, ESC_ESC_COMMA), ",", ESC_COMMA);
    }

    private static String unescapeCommas(String s) {
        return ArgumentParser.replace(ArgumentParser.replace(s, ESC_COMMA, ","), ESC_ESC_COMMA, ESC_COMMA);
    }

    public static String encodeArguments(String[] args) {
        StringBuffer sb = new StringBuffer();
        if (args.length > 0) {
            if (ArgumentParser.isBounded(args[0])) {
                sb.append(args[0]);
            } else {
                sb.append(ArgumentParser.escapeCommas(args[0]));
            }
            for (int i = 1; i < args.length; ++i) {
                sb.append(",");
                if (ArgumentParser.isBounded(args[i])) {
                    sb.append(args[i]);
                    continue;
                }
                sb.append(ArgumentParser.escapeCommas(args[i]));
            }
        }
        return sb.toString();
    }

    public static String[] parseArgumentList(String encodedArgs) {
        ArrayList<String> alist = new ArrayList<String>();
        if (encodedArgs == null || "".equals(encodedArgs)) {
            return new String[0];
        }
        encodedArgs = ArgumentParser.replace(encodedArgs, "\\,", ESC_COMMA);
        Iterator iter = new Tokenizer(encodedArgs).iterator();
        while (iter.hasNext()) {
            String next;
            String str = (String)iter.next();
            if (str.trim().startsWith("[") && !str.trim().endsWith("]")) {
                while (iter.hasNext()) {
                    next = (String)iter.next();
                    str = str + "," + next;
                    if (!next.trim().endsWith("]")) continue;
                    break;
                }
            } else if (str.trim().startsWith("\"") && !str.trim().endsWith("\"")) {
                while (iter.hasNext()) {
                    next = (String)iter.next();
                    str = str + "," + next;
                    if (!next.trim().endsWith("\"")) continue;
                    break;
                }
            } else if (str.trim().startsWith("'") && !str.trim().endsWith("'")) {
                while (iter.hasNext()) {
                    next = (String)iter.next();
                    str = str + "," + next;
                    if (!next.trim().endsWith("'")) continue;
                    break;
                }
            }
            if (NULL.equals(str.trim())) {
                alist.add(null);
                continue;
            }
            if (!str.startsWith("[")) {
                str = ArgumentParser.unescapeCommas(str);
            }
            alist.add(str);
        }
        return alist.toArray(new String[alist.size()]);
    }

    public static String substitute(Resolver resolver, String arg) {
        if (arg == null) {
            return arg;
        }
        int i = 0;
        int marker = 0;
        StringBuffer sb = new StringBuffer();
        while ((i = arg.indexOf("${", marker)) != -1) {
            int end;
            if (marker < i) {
                sb.append(arg.substring(marker, i));
                marker = i;
            }
            if ((end = arg.indexOf("}", i)) == -1) break;
            String name = arg.substring(i + 2, end);
            Object value = resolver.getProperty(name);
            if (value == null) {
                value = System.getProperty(name);
            }
            if (value == null) {
                value = arg.substring(i, end + 1);
            }
            sb.append(ArgumentParser.toString(value));
            marker = end + 1;
        }
        sb.append(arg.substring(marker));
        return sb.toString();
    }

    public static Object eval(Resolver resolver, String arg, Class cls) throws IllegalArgumentException, NoSuchReferenceException, ComponentSearchException {
        arg = ArgumentParser.substitute(resolver, arg);
        Object result = null;
        try {
            if (arg == null || arg.equals(NULL)) {
                result = null;
            } else if (cls.equals(class$java$lang$Boolean == null ? (class$java$lang$Boolean = ArgumentParser.class$("java.lang.Boolean")) : class$java$lang$Boolean) || cls.equals(Boolean.TYPE)) {
                result = Boolean.valueOf(arg.trim());
            } else if (cls.equals(class$java$lang$Short == null ? (class$java$lang$Short = ArgumentParser.class$("java.lang.Short")) : class$java$lang$Short) || cls.equals(Short.TYPE)) {
                result = Short.valueOf(arg.trim());
            } else if (cls.equals(class$java$lang$Integer == null ? (class$java$lang$Integer = ArgumentParser.class$("java.lang.Integer")) : class$java$lang$Integer) || cls.equals(Integer.TYPE)) {
                result = Integer.valueOf(arg.trim());
            } else if (cls.equals(class$java$lang$Long == null ? (class$java$lang$Long = ArgumentParser.class$("java.lang.Long")) : class$java$lang$Long) || cls.equals(Long.TYPE)) {
                result = Long.valueOf(arg.trim());
            } else if (cls.equals(class$java$lang$Float == null ? (class$java$lang$Float = ArgumentParser.class$("java.lang.Float")) : class$java$lang$Float) || cls.equals(Float.TYPE)) {
                result = Float.valueOf(arg.trim());
            } else if (cls.equals(class$java$lang$Double == null ? (class$java$lang$Double = ArgumentParser.class$("java.lang.Double")) : class$java$lang$Double) || cls.equals(Double.TYPE)) {
                result = Double.valueOf(arg.trim());
            } else if (cls.equals(class$abbot$script$ComponentReference == null ? (class$abbot$script$ComponentReference = ArgumentParser.class$("org.robotframework.abbot.script.ComponentReference")) : class$abbot$script$ComponentReference)) {
                ComponentReference ref = resolver.getComponentReference(arg.trim());
                if (ref == null) {
                    throw new NoSuchReferenceException("The resolver " + resolver + " has no reference '" + arg + "'");
                }
                result = ref;
            } else if ((class$java$awt$Component == null ? (class$java$awt$Component = ArgumentParser.class$("java.awt.Component")) : class$java$awt$Component).isAssignableFrom(cls)) {
                ComponentReference ref = resolver.getComponentReference(arg.trim());
                if (ref == null) {
                    throw new NoSuchReferenceException("The resolver " + resolver + " has no reference '" + arg + "'");
                }
                result = ArgumentParser.waitForComponentAvailable(ref);
            } else if (cls.equals(class$java$lang$String == null ? (class$java$lang$String = ArgumentParser.class$("java.lang.String")) : class$java$lang$String)) {
                result = arg;
            } else if (cls.isArray() && arg.trim().startsWith("[")) {
                arg = arg.trim();
                String[] args = ArgumentParser.parseArgumentList(arg.substring(1, arg.length() - 1));
                Class<?> base = cls.getComponentType();
                Object arr = Array.newInstance(base, args.length);
                for (int i = 0; i < args.length; ++i) {
                    Object obj = ArgumentParser.eval(resolver, args[i], base);
                    Array.set(arr, i, obj);
                }
                result = arr;
            } else {
                Parser parser = ArgumentParser.getParser(cls);
                if (parser != null) {
                    result = parser.parse(arg.trim());
                } else {
                    String msg = Strings.get("parser.conversion_error", new Object[]{arg.trim(), cls.getName()});
                    throw new IllegalArgumentException(msg);
                }
            }
            return result;
        }
        catch (NumberFormatException nfe) {
            String msg = Strings.get("parser.conversion_error", new Object[]{arg.trim(), cls.getName()});
            throw new IllegalArgumentException(msg);
        }
    }

    public static Object[] eval(Resolver resolver, String[] args, Class[] params) throws IllegalArgumentException, NoSuchReferenceException, ComponentSearchException {
        Object[] plist = new Object[params.length];
        for (int i = 0; i < plist.length; ++i) {
            plist[i] = ArgumentParser.eval(resolver, args[i], params[i]);
        }
        return plist;
    }

    public static String replace(String str, String s1, String s2) {
        StringBuffer sb = new StringBuffer(str);
        int index = 0;
        while ((index = sb.toString().indexOf(s1, index)) != -1) {
            sb.delete(index, index + s1.length());
            sb.insert(index, s2);
            index += s2.length();
        }
        return sb.toString();
    }

    private static Component waitForComponentAvailable(final ComponentReference ref) throws ComponentSearchException {
        try {
            ComponentTester tester = ComponentTester.getTester(class$java$awt$Component == null ? (class$java$awt$Component = ArgumentParser.class$("java.awt.Component")) : class$java$awt$Component);
            tester.wait(new Condition(){

                public boolean test() {
                    try {
                        ref.getComponent();
                    }
                    catch (ComponentNotFoundException e) {
                        return false;
                    }
                    catch (MultipleComponentsFoundException multipleComponentsFoundException) {
                        // empty catch block
                    }
                    return true;
                }

                public String toString() {
                    return ref + " to become available";
                }
            }, (long)ComponentTester.componentDelay);
        }
        catch (WaitTimedOutError wto) {
            String msg = "Could not find " + ref + ": " + Step.toXMLString(ref);
            throw new ComponentNotFoundException(msg);
        }
        return ref.getComponent();
    }

    public static String toString(Object value) {
        if (value == null) {
            return NULL;
        }
        if (value.getClass().isArray()) {
            StringBuffer sb = new StringBuffer();
            sb.append("[");
            for (int i = 0; i < Array.getLength(value); ++i) {
                Object o = Array.get(value, i);
                if (i > 0) {
                    sb.append(",");
                }
                sb.append(ArgumentParser.toString(o));
            }
            sb.append("]");
            return sb.toString();
        }
        String s = value.toString();
        if (s == null) {
            return NULL;
        }
        if (ArgumentParser.isDefaultToString(s)) {
            return DEFAULT_TOSTRING;
        }
        return s;
    }

    public static boolean isDefaultToString(String s) {
        if (s == null) {
            return false;
        }
        int at = s.indexOf("@");
        if (at != -1) {
            String hash = s.substring(at + 1, s.length());
            try {
                Integer.parseInt(hash, 16);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Tokenizer
    extends ArrayList {
        public Tokenizer(String input) {
            while (true) {
                int index;
                if ((index = input.indexOf(",")) == -1) break;
                this.add(input.substring(0, index));
                input = input.substring(index + 1);
            }
            this.add(input);
        }
    }
}

