/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.script;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.SwingUtilities;
import org.robotframework.abbot.AssertionFailedError;
import org.robotframework.abbot.ExitException;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.NoExitSecurityManager;
import org.robotframework.abbot.finder.Hierarchy;
import org.robotframework.abbot.i18n.Strings;
import org.robotframework.abbot.script.ForkedStepRunner;
import org.robotframework.abbot.script.InvalidScriptException;
import org.robotframework.abbot.script.Launch;
import org.robotframework.abbot.script.Script;
import org.robotframework.abbot.script.Sequence;
import org.robotframework.abbot.script.Step;
import org.robotframework.abbot.script.StepEvent;
import org.robotframework.abbot.script.StepListener;
import org.robotframework.abbot.script.Terminate;
import org.robotframework.abbot.script.UIContext;
import org.robotframework.abbot.util.AWTFixtureHelper;
import org.robotframework.abbot.util.EDTExceptionCatcher;
import org.robotframework.abbot.util.SystemState;

public class StepRunner {
    private static UIContext currentContext = null;
    private boolean stopOnFailure = true;
    private boolean stopOnError = true;
    private boolean terminateOnError = true;
    private transient boolean terminateOnStop = false;
    private ArrayList listeners = new ArrayList();
    private Map errors = new HashMap();
    private transient boolean stop = false;
    private EDTExceptionCatcher catcher;
    protected AWTFixtureHelper helper;
    protected Hierarchy hierarchy;

    public StepRunner() {
        this(new AWTFixtureHelper());
    }

    public StepRunner(AWTFixtureHelper helper) {
        this.helper = helper;
        this.catcher = new EDTExceptionCatcher();
        this.catcher.install();
        this.hierarchy = helper.getHierarchy();
    }

    public Hierarchy getHierarchy() {
        Hierarchy h = currentContext != null && currentContext.isLaunched() ? currentContext.getHierarchy() : this.hierarchy;
        return h;
    }

    public UIContext getCurrentContext() {
        return currentContext;
    }

    public void setStopOnFailure(boolean stop) {
        this.stopOnFailure = stop;
    }

    public void setStopOnError(boolean stop) {
        this.stopOnError = stop;
    }

    public boolean getStopOnFailure() {
        return this.stopOnFailure;
    }

    public boolean getStopOnError() {
        return this.stopOnError;
    }

    public void stop() {
        this.stop(false);
    }

    public void stop(boolean terminate) {
        this.stop = true;
        this.terminateOnStop = terminate;
    }

    public boolean stopped() {
        return this.stop;
    }

    protected SecurityManager createSecurityManager() {
        return new ExitHandler();
    }

    protected synchronized void installSecurityManager() {
        if (System.getSecurityManager() == null && !Boolean.getBoolean("org.robotframework.abbot.no_security_manager")) {
            Log.debug("Installing sm");
            System.setSecurityManager(this.createSecurityManager());
        }
    }

    protected synchronized void removeSecurityManager() {
        if (System.getSecurityManager() instanceof ExitHandler) {
            System.setSecurityManager(null);
        }
    }

    private void updateContext(UIContext context) {
        if (!context.equivalent(currentContext)) {
            Log.debug("current=" + currentContext + ", new=" + context);
            if (currentContext != null) {
                currentContext.terminate();
            }
            currentContext = context;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Step step) throws Throwable {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new Error(Strings.get("runner.bad_invocation"));
        }
        SystemState.clearLockingKeys();
        UIContext context = null;
        if (step instanceof Script) {
            context = step instanceof UIContext ? (UIContext)((Object)step) : ((Script)step).getUIContext();
        } else if (step instanceof UIContext) {
            context = (UIContext)((Object)step);
        }
        if (context != null) {
            this.updateContext(context);
        }
        this.installSecurityManager();
        boolean completed = false;
        this.clearErrors();
        try {
            if (step instanceof Script && ((Script)step).isForked()) {
                Log.debug("Forking " + step);
                ForkedStepRunner runner = new ForkedStepRunner(this);
                runner.listeners.addAll(this.listeners);
                try {
                    ((StepRunner)runner).runStep(step);
                }
                finally {
                    this.errors.putAll(runner.errors);
                }
            } else {
                this.runStep(step);
            }
            completed = !this.stopped();
        }
        catch (ExitException ee) {
            Log.debug("App tried to exit");
            this.terminate();
        }
        finally {
            if (step instanceof Script && (!completed || this.errors.size() != 0) && this.stopped() && this.terminateOnStop) {
                this.terminate();
            }
            this.removeSecurityManager();
        }
    }

    public void setTerminateOnError(boolean state) {
        this.terminateOnError = state;
    }

    public boolean getTerminateOnError() {
        return this.terminateOnError;
    }

    protected void clearErrors() {
        this.stop = false;
        this.errors.clear();
    }

    protected void checkFile(Script script) throws InvalidScriptException {
        File file = script.getFile();
        if (!file.exists() && !file.getName().startsWith(Script.UNTITLED_FILE)) {
            String msg = "The script '" + script.getFilename() + "' does not exist at the expected location '" + file.getAbsolutePath() + "'";
            throw new InvalidScriptException(msg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runStep(Step step) throws Throwable {
        if (step instanceof Script) {
            this.checkFile((Script)step);
            ((Script)step).setHierarchy(this.getHierarchy());
        }
        Log.debug("Running " + step);
        this.fireStepStart(step);
        if (this.stopped()) {
            Log.debug("Already stopped, skipping " + step);
        } else {
            Throwable exception = null;
            long exceptionTime = -1L;
            try {
                if (step instanceof Launch) {
                    ((Launch)step).setThreadedLaunchListener(new LaunchListener());
                }
                if (step instanceof Sequence) {
                    ((Sequence)step).runStep(this);
                } else {
                    step.run();
                }
                Log.debug("Finished " + step);
                if (step instanceof Terminate) {
                    this.terminate();
                }
            }
            catch (Throwable e) {
                exceptionTime = System.currentTimeMillis();
                exception = e;
            }
            finally {
                long edtExceptionTime = EDTExceptionCatcher.getThrowableTime();
                Throwable edtException = EDTExceptionCatcher.getThrowable();
                if (edtException != null && (exception == null || edtExceptionTime < exceptionTime)) {
                    exception = edtException;
                }
            }
            if (exception != null) {
                if (exception instanceof junit.framework.AssertionFailedError) {
                    Log.debug("failure in " + step + ": " + exception);
                    this.fireStepFailure(step, exception);
                    if (this.stopOnFailure) {
                        this.stop(this.terminateOnError);
                        throw exception;
                    }
                } else {
                    Log.debug("error in " + step + ": " + exception);
                    this.fireStepError(step, exception);
                    if (this.stopOnError) {
                        this.stop(this.terminateOnError);
                        throw exception;
                    }
                }
            }
            this.fireStepEnd(step);
        }
    }

    public void launch(Script step) throws Throwable {
        UIContext ctxt = step.getUIContext();
        if (ctxt != null) {
            ctxt.launch(this);
        }
    }

    public void terminate() {
        if (currentContext != null) {
            currentContext.terminate();
        }
        if (this.helper != null) {
            Log.debug("restoring UI state");
            this.helper.restore();
        }
    }

    protected void setError(Step step, Throwable thr) {
        if (thr != null) {
            this.errors.put(step, thr);
        } else {
            this.errors.remove(step);
        }
    }

    public Throwable getError(Step step) {
        return (Throwable)this.errors.get(step);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStepListener(StepListener sl) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.add(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStepListener(StepListener sl) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            this.listeners.remove(sl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireStepEvent(StepEvent event) {
        Iterator iter;
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            iter = ((ArrayList)this.listeners.clone()).iterator();
        }
        while (iter.hasNext()) {
            StepListener sl = (StepListener)iter.next();
            sl.stateChanged(event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireStepEvent(Step step, String type, int val, Throwable throwable) {
        ArrayList arrayList = this.listeners;
        synchronized (arrayList) {
            if (this.listeners.size() != 0) {
                StepEvent event = new StepEvent(step, type, val, throwable);
                this.fireStepEvent(event);
            }
        }
    }

    protected void fireStepStart(Step step) {
        this.fireStepEvent(step, "step-start", 0, null);
    }

    protected void fireStepProgress(Step step, int val) {
        this.fireStepEvent(step, "step-progress", val, null);
    }

    protected void fireStepEnd(Step step) {
        this.fireStepEvent(step, "step-end", 0, null);
    }

    protected void fireStepFailure(Step step, Throwable afe) {
        this.setError(step, afe);
        this.fireStepEvent(step, "step-failure", 0, afe);
    }

    protected void fireStepError(Step step, Throwable thr) {
        this.setError(step, thr);
        this.fireStepEvent(step, "step-error", 0, thr);
    }

    protected class ExitHandler
    extends NoExitSecurityManager {
        protected ExitHandler() {
        }

        public void checkRead(String file) {
        }

        protected void exitCalled(int status) {
            Log.debug("Terminating from security manager");
            StepRunner.this.terminate();
        }
    }

    private class LaunchListener
    implements Launch.ThreadedLaunchListener {
        private LaunchListener() {
        }

        public void stepFailure(Launch step, AssertionFailedError afe) {
            StepRunner.this.fireStepFailure(step, (Throwable)((Object)afe));
            if (StepRunner.this.stopOnFailure) {
                StepRunner.this.stop(StepRunner.this.terminateOnError);
            }
        }

        public void stepError(Launch step, Throwable thr) {
            StepRunner.this.fireStepError(step, thr);
            if (StepRunner.this.stopOnError) {
                StepRunner.this.stop(StepRunner.this.terminateOnError);
            }
        }
    }
}

