/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.tester;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import javax.accessibility.AccessibleContext;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.KeyStroke;
import org.robotframework.abbot.AssertionFailedError;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.i18n.Strings;
import org.robotframework.abbot.script.ArgumentParser;
import org.robotframework.abbot.tester.ActionFailedException;
import org.robotframework.abbot.tester.ComponentLocation;
import org.robotframework.abbot.tester.ComponentTester;
import org.robotframework.abbot.tester.ContainerTester;
import org.robotframework.abbot.util.AWT;

public class JComponentTester
extends ContainerTester {
    private static final String LABELED_BY_PROPERTY = "labeledBy";
    static /* synthetic */ Class class$javax$swing$JComponent;

    public String deriveTag(Component comp) {
        if (this.isCustom(comp.getClass())) {
            return null;
        }
        JComponent jComp = (JComponent)comp;
        String tag = null;
        JLabel label = (JLabel)((JComponent)comp).getClientProperty(LABELED_BY_PROPERTY);
        if (label != null && label.getText() != null && label.getText().length() > 0) {
            tag = label.getText();
        }
        if (tag == null || "".equals(tag)) {
            AccessibleContext context = jComp.getAccessibleContext();
            tag = this.deriveAccessibleTag(context);
        }
        if (tag == null || "".equals(tag)) {
            tag = super.deriveTag(comp);
        }
        return tag;
    }

    public void actionClick(Component c, ComponentLocation loc, String buttons, int count) {
        this.actionClick(c, loc, AWT.getModifiers(buttons), count);
    }

    public void actionClick(Component c, ComponentLocation loc, int buttons, int count) {
        if (c instanceof JComponent) {
            this.scrollToVisible(c, loc.getBounds(c));
        }
        super.actionClick(c, loc, buttons, count);
    }

    public void actionDrag(Component c, ComponentLocation loc, String mods) {
        this.actionDrag(c, loc, AWT.getModifiers(mods));
    }

    public void actionDrag(Component c, ComponentLocation loc, int modifiers) {
        if (c instanceof JComponent) {
            this.scrollToVisible(c, loc.getBounds(c));
        }
        super.actionDrag(c, loc, modifiers);
    }

    public void actionDrop(Component c, ComponentLocation loc) {
        if (c instanceof JComponent) {
            this.scrollToVisible(c, loc.getBounds(c));
        }
        super.actionDrop(c, loc);
    }

    public void mousePress(Component comp, int x, int y, int buttons) {
        if (comp instanceof JComponent) {
            this.scrollToVisible(comp, x, y);
        }
        super.mousePress(comp, x, y, buttons);
    }

    protected void scrollToVisible(Component comp, int x, int y) {
        Rectangle rect = new Rectangle(x, y, 1, 1);
        this.scrollToVisible(comp, rect);
    }

    protected void scrollRectToVisible(final JComponent jc, final Rectangle rect) {
        Log.debug("Scroll to visible: " + rect);
        this.invokeAndWait(new Runnable(){

            public void run() {
                jc.scrollRectToVisible(rect);
            }
        });
    }

    protected boolean isVisible(JComponent c, Rectangle rect) {
        Rectangle visible = c.getVisibleRect();
        return visible.contains(rect);
    }

    protected boolean isVisible(JComponent c, int x, int y) {
        Rectangle visible = c.getVisibleRect();
        return visible.contains(x, y);
    }

    protected void scrollToVisible(Component comp, Rectangle rect) {
        JComponent jc = (JComponent)comp;
        if (!this.isVisible(jc, rect)) {
            this.scrollRectToVisible(jc, rect);
            if (!this.isVisible(jc, rect.x, rect.y)) {
                String msg = Strings.get("tester.JComponent.not_visible", new Object[]{new Integer(rect.x), new Integer(rect.y), jc});
                throw new ActionFailedException(msg);
            }
        }
    }

    public void actionScrollToVisible(Component comp, ComponentLocation loc) {
        this.scrollToVisible(comp, loc.getBounds(comp));
        this.waitForIdle();
    }

    public void actionScrollToVisible(Component comp, int x, int y) {
        this.actionScrollToVisible(comp, new ComponentLocation(new Point(x, y)));
    }

    public void actionScrollToVisible(Component comp, int x, int y, int width, int height) {
        this.scrollToVisible(comp, new Rectangle(x, y, width, height));
        this.waitForIdle();
    }

    public void actionActionMap(Component comp, String name) {
        KeyStroke ks;
        this.focus(comp, true);
        JComponent jc = (JComponent)comp;
        ActionMap am = jc.getActionMap();
        Action action = am.get(name);
        Object key = name;
        if (action == null) {
            Object[] keys = am.allKeys();
            for (int i = 0; keys != null && i < keys.length; ++i) {
                Action value = am.get(keys[i]);
                if (!(value instanceof Action) || !name.equals(value.getValue("Name"))) continue;
                action = value;
                key = keys[i];
                break;
            }
        }
        if (action == null) {
            String available = "Available actions are the following:";
            Object[] names = am.allKeys();
            if (names != null) {
                Arrays.sort(names, new Comparator(){

                    public int compare(Object o1, Object o2) {
                        String n1 = o1.toString();
                        String n2 = o2.toString();
                        return n1.compareTo(n2);
                    }
                });
                for (int i = 0; i < names.length; ++i) {
                    available = available + "\n" + names[i];
                    if (names[i] instanceof String) continue;
                    available = available + " (" + names[i].getClass() + ")";
                }
            }
            throw new AssertionFailedError("No such action '" + name + "'. " + available);
        }
        InputMap im = jc.getInputMap();
        KeyStroke[] events = im.allKeys();
        ArrayList<KeyStroke> strokes = new ArrayList<KeyStroke>();
        for (int i = 0; events != null && i < events.length; ++i) {
            ks = events[i];
            if (!key.equals(im.get(ks))) continue;
            strokes.add(ks);
        }
        if (strokes.size() > 0) {
            Iterator i = strokes.iterator();
            while (i.hasNext()) {
                ks = (KeyStroke)i.next();
                Log.debug("Generating keystroke " + ks + " for action " + name);
                try {
                    if (ks.getKeyCode() == 0) {
                        this.keyStroke(ks.getKeyChar());
                    } else {
                        this.key(ks.getKeyCode(), ks.getModifiers());
                    }
                    this.waitForIdle();
                    return;
                }
                catch (IllegalArgumentException e) {
                }
            }
        }
        String msg = "No valid input event found for action with key '" + name + "'";
        if (strokes.size() > 0) {
            msg = msg + " (tried " + strokes + ")";
        }
        throw new ActionFailedException(msg);
    }

    public static JComponentTester getTester(JComponent c) {
        return (JComponentTester)ComponentTester.getTester(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JComponentTester.class$("javax.swing.JComponent")) : class$javax$swing$JComponent);
    }

    public static String convertRendererToString(Component cr) {
        String string = null;
        if (cr instanceof JLabel) {
            String label = ((JLabel)cr).getText();
            if (label != null) {
                label = label.trim();
            }
            if (!"".equals(label) && !ArgumentParser.isDefaultToString(label)) {
                string = label;
            }
        } else {
            Class<?> cls = cr.getClass();
            String className = cls.getName();
            className = className.substring(className.lastIndexOf(".") + 1);
            try {
                Method method = cls.getMethod("getText", new Class[0]);
                if (method != null) {
                    String label = (String)method.invoke((Object)cr, new Object[0]);
                    if (label != null) {
                        label = label.trim();
                    }
                    if (!"".equals(label)) {
                        string = label;
                    }
                }
            }
            catch (IllegalAccessException e) {
                Log.log("Error calling getText on " + className, e);
            }
            catch (InvocationTargetException e) {
                Log.log("Error calling getText on " + className, e);
            }
            catch (NoSuchMethodException e) {
                Log.log("Cannot find getText method on render " + className, e);
            }
        }
        if (string != null) {
            String parsed = ArgumentParser.toString(string);
            String filtered = parsed == "<default-tostring>" ? null : parsed;
            return filtered;
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

