/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.util;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Iterator;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.finder.BasicFinder;
import org.robotframework.abbot.finder.ComponentFinder;
import org.robotframework.abbot.finder.ComponentNotFoundException;
import org.robotframework.abbot.finder.ComponentSearchException;
import org.robotframework.abbot.finder.Hierarchy;
import org.robotframework.abbot.finder.MultipleComponentsFoundException;
import org.robotframework.abbot.finder.TestHierarchy;
import org.robotframework.abbot.finder.matchers.ClassMatcher;
import org.robotframework.abbot.finder.matchers.WindowMatcher;
import org.robotframework.abbot.tester.Robot;
import org.robotframework.abbot.tester.WindowTracker;
import org.robotframework.abbot.util.AWT;
import org.robotframework.abbot.util.Bugs;
import org.robotframework.abbot.util.EDTExceptionCatcher;
import org.robotframework.abbot.util.Properties;
import org.robotframework.abbot.util.SystemState;
import org.robotframework.abbot.util.WeakAWTEventListener;

public class AWTFixtureHelper {
    public static final int EVENT_GENERATION_DELAY = 5000;
    public static final int WINDOW_DELAY = 20000;
    public static final int POPUP_DELAY = 10000;
    private AWTEventListener listener = null;
    private SystemState state = new SystemState();
    private Robot robot;
    private WindowTracker tracker;
    private Hierarchy hierarchy;
    private int modifiers;
    static /* synthetic */ Class class$java$awt$Dialog;

    public AWTFixtureHelper() {
        this(new TestHierarchy());
    }

    public AWTFixtureHelper(Hierarchy hierarchy) {
        this.hierarchy = hierarchy;
        try {
            new EDTExceptionCatcher().install();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        if (Boolean.getBoolean("org.robotframework.abbot.fixture.log_events")) {
            long mask = Properties.getProperty("org.robotframework.abbot.fixture.event_mask", Long.MIN_VALUE, Long.MAX_VALUE, 2813L);
            Log.log("Using mask value " + mask);
            this.listener = new AWTEventListener(){

                public void eventDispatched(AWTEvent event) {
                    if (AWTFixtureHelper.this.listener != null) {
                        Log.log(Robot.toString(event));
                    }
                }
            };
            new WeakAWTEventListener(this.listener, mask);
        }
        this.robot = new Robot();
        this.tracker = WindowTracker.getTracker();
        SystemState.clearLockingKeys();
        this.robot.reset();
        if (Bugs.hasMultiClickFrameBug()) {
            this.robot.delay(500);
        }
    }

    public Robot getRobot() {
        return this.robot;
    }

    public WindowTracker getWindowTracker() {
        return this.tracker;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    public Throwable getEventDispatchError() {
        return EDTExceptionCatcher.getThrowable();
    }

    public long getEventDispatchErrorTime() {
        return EDTExceptionCatcher.getThrowableTime();
    }

    public void setModifiers(int modifiers, boolean pressed) {
        this.modifiers = pressed ? (this.modifiers |= modifiers) : (this.modifiers &= ~modifiers);
        this.robot.setModifiers(modifiers, pressed);
        this.robot.waitForIdle();
    }

    protected void disposeAll() {
        Iterator iter = this.hierarchy.getRoots().iterator();
        while (iter.hasNext()) {
            this.hierarchy.dispose((Window)iter.next());
        }
    }

    public void restore() {
        if (AWT.isAWTPopupMenuBlocking()) {
            AWT.dismissAWTPopup();
        }
        this.state.restore();
        System.gc();
        System.runFinalization();
    }

    public void dispose() {
        if (this.robot != null) {
            int buttons;
            if (this.modifiers != 0) {
                this.robot.setModifiers(this.modifiers, false);
                this.modifiers = 0;
            }
            if ((buttons = Robot.getState().getButtons()) != 0) {
                Log.debug("release " + AWT.getMouseModifiers(buttons));
                this.robot.mouseRelease(buttons);
            }
            AWTFixtureHelper aWTFixtureHelper = this;
            if (aWTFixtureHelper.robot.getState().isNativeDragActive()) {
                this.robot.keyPress(27);
                this.robot.keyRelease(27);
            }
        }
        this.disposeAll();
        this.restore();
    }

    public Frame showFrame(Component comp) {
        return this.showFrame(comp, null);
    }

    public Frame showFrame(Component comp, Dimension size) {
        return this.showFrame(comp, size, "Test Frame");
    }

    public Frame showFrame(Component comp, Dimension size, String title) {
        JFrame frame = new JFrame(title);
        frame.setDefaultCloseOperation(3);
        JPanel pane = (JPanel)frame.getContentPane();
        pane.setBorder(new EmptyBorder(10, 10, 10, 10));
        pane.add(comp);
        this.showWindow(frame, size, true);
        return frame;
    }

    public void showWindow(Window w) {
        this.showWindow(w, null, true);
    }

    public void showWindow(Window w, Dimension size) {
        this.showWindow(w, size, true);
    }

    public void showWindow(final Window w, final Dimension size, final boolean pack) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (pack) {
                    w.pack();
                    w.setLocation(100, 100);
                }
                if (size != null) {
                    w.setSize(size.width, size.height);
                }
                w.setVisible(true);
            }
        });
        this.waitForWindow(w, true);
    }

    public void waitForWindow(Window w, boolean visible) {
        long start = System.currentTimeMillis();
        while (Robot.getEventMode() == Robot.EM_ROBOT && visible && !this.getWindowTracker().isWindowReady(w) || w.isShowing() != visible) {
            long elapsed = System.currentTimeMillis() - start;
            if (elapsed > 20000L) {
                throw new RuntimeException("Timed out waiting for Window to " + (visible ? "open" : "close") + " (" + elapsed + "ms)");
            }
            this.getRobot().sleep();
        }
    }

    public void hideWindow(final Window w) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                w.setVisible(false);
            }
        });
        this.waitForWindow(w, false);
        this.getRobot().waitForIdle();
    }

    public void disposeWindow(Window w) {
        w.dispose();
        this.waitForWindow(w, false);
        this.getRobot().waitForIdle();
    }

    public void invokeAndWait(Runnable runnable) {
        this.getRobot().invokeAndWait(runnable);
    }

    public void invokeLater(Runnable runnable) {
        this.getRobot().invokeLater(runnable);
    }

    public void installPopup(Component invoker, final JPopupMenu popup) {
        invoker.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                this.mouseReleased(e);
            }

            public void mouseClicked(MouseEvent e) {
                this.mouseReleased(e);
            }

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
    }

    public void showPopup(JPopupMenu popup, Component invoker) {
        this.showPopup(popup, invoker, invoker.getWidth() / 2, invoker.getHeight() / 2);
    }

    public void showPopup(final JPopupMenu popup, final Component invoker, final int x, final int y) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                popup.show(invoker, x, y);
            }
        });
        long start = System.currentTimeMillis();
        while (!popup.isShowing()) {
            if (System.currentTimeMillis() - start > 10000L) {
                throw new RuntimeException("Timed out waiting for popup to show");
            }
            this.robot.sleep();
        }
        this.waitForWindow(SwingUtilities.getWindowAncestor(popup), true);
    }

    public Dialog showModalDialog(Runnable showAction) throws ComponentSearchException {
        return this.showModalDialog(showAction, new BasicFinder(this.hierarchy));
    }

    public Dialog showModalDialog(final Runnable showAction, ComponentFinder finder) throws ComponentSearchException {
        final boolean[] modalRun = new boolean[]{false};
        final boolean[] invocationFinished = new boolean[]{false};
        EventQueue.invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                modalRun[0] = true;
                try {
                    showAction.run();
                }
                finally {
                    invocationFinished[0] = true;
                }
            }
        });
        while (!modalRun[0]) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {}
        }
        ClassMatcher matcher = new ClassMatcher(class$java$awt$Dialog == null ? (class$java$awt$Dialog = AWTFixtureHelper.class$("java.awt.Dialog")) : class$java$awt$Dialog, true){

            public boolean matches(Component c) {
                return super.matches(c) && ((Dialog)c).isModal() && AWT.containsFocus(c);
            }
        };
        long start = System.currentTimeMillis();
        boolean finished = false;
        while (true) {
            try {
                return (Dialog)finder.find(matcher);
            }
            catch (ComponentSearchException e) {
                block11: {
                    block10: {
                        if (!invocationFinished[0]) break block10;
                        if (finished) break block11;
                        finished = true;
                    }
                    if (System.currentTimeMillis() - start > 10000L) {
                        throw new ComponentSearchException("Timed out waiting for dialog to be ready");
                    }
                    this.robot.sleep();
                    continue;
                }
                throw new ComponentSearchException("No dialog was displayed (premature return=" + finished + ")");
            }
            break;
        }
    }

    public boolean isShowing(String id) {
        return this.isShowing(id, new BasicFinder(this.hierarchy));
    }

    public boolean isShowing(String id, ComponentFinder finder) {
        try {
            finder.find(new WindowMatcher(id, true));
        }
        catch (ComponentNotFoundException e) {
            return false;
        }
        catch (MultipleComponentsFoundException multipleComponentsFoundException) {
            // empty catch block
        }
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

