/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.util;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.robotframework.abbot.Log;

public class InputStreamHandler
extends Thread {
    private InputStream stream = null;

    public InputStreamHandler(InputStream stream) {
        super("Process Input Stream Handler");
        this.setDaemon(true);
        this.stream = new BufferedInputStream(stream);
    }

    public void handleBytes(byte[] buf, int count) {
    }

    private void close() {
        try {
            this.stream.close();
        }
        catch (IOException io) {
            Log.debug(io);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        int BUFSIZE = 256;
        byte[] buf = new byte[BUFSIZE];
        Log.debug("Stream reader started");
        try {
            while (true) {
                Log.debug("Reading from stream");
                int count = this.stream.read(buf, 0, buf.length);
                if (count == -1) {
                    Log.debug("end of stream");
                    break;
                }
                if (count == 0) {
                    Log.debug("No input, sleeping");
                    try {
                        InputStreamHandler.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Log.debug(e);
                    }
                    continue;
                }
                if (count <= 0) continue;
                Log.debug("Got " + count + " bytes");
                this.handleBytes(buf, count);
            }
        }
        catch (IOException io) {
            Log.debug(io);
        }
        this.close();
        Log.debug("stream handler terminating");
    }
}

