/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.laughingpanda.jretrofit;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;

abstract class AbstractMethodLookupHelper
implements Serializable {
    private Object target;

    protected AbstractMethodLookupHelper(Object object) {
        this.target = object;
    }

    protected Method findCompatibleMethod(Method method) {
        Method[] methodArray = this.getTarget().getClass().getMethods();
        Method[] methodArray2 = this.getTarget().getClass().getDeclaredMethods();
        ArrayList<Method> arrayList = new ArrayList<Method>();
        arrayList.addAll(Arrays.asList(methodArray));
        arrayList.addAll(Arrays.asList(methodArray2));
        Method[] methodArray3 = arrayList.toArray(new Method[arrayList.size()]);
        for (int i = 0; i < methodArray3.length; ++i) {
            Method method2 = methodArray3[i];
            if (!this.areMethodsCompatible(method, method2)) continue;
            if (!method2.isAccessible()) {
                method2.setAccessible(true);
            }
            return method2;
        }
        throw new UnsupportedOperationException("Target object '" + this.getTarget() + "' does not have a method which is compatible with '" + method + "'!");
    }

    private boolean areMethodsCompatible(Method method, Method method2) {
        return this.areNamesCompatible(method, method2) && this.areParametersCompatible(method, method2) && this.areReturnValuesCompatible(method, method2);
    }

    private boolean areNamesCompatible(Method method, Method method2) {
        return method.getName().equals(method2.getName());
    }

    private boolean areParametersCompatible(Method method, Method method2) {
        Class<?>[] classArray;
        Class<?>[] classArray2 = method.getParameterTypes();
        if (classArray2.length != (classArray = method2.getParameterTypes()).length) {
            return false;
        }
        for (int i = 0; i < classArray2.length; ++i) {
            Class<?> clazz = classArray[i];
            Class<?> clazz2 = classArray2[i];
            if (clazz.isAssignableFrom(clazz2)) continue;
            return false;
        }
        return true;
    }

    private boolean areReturnValuesCompatible(Method method, Method method2) {
        Class<?> clazz = method.getReturnType();
        Class<?> clazz2 = method2.getReturnType();
        return clazz.isAssignableFrom(clazz2);
    }

    abstract Method findMethodToCall(Method var1);

    protected final Object getTarget() {
        return this.target;
    }
}

