/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers;

import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;
import org.robotframework.org.netbeans.jemmy.drivers.ButtonDriver;
import org.robotframework.org.netbeans.jemmy.drivers.DefaultDriverInstaller;
import org.robotframework.org.netbeans.jemmy.drivers.Driver;
import org.robotframework.org.netbeans.jemmy.drivers.FocusDriver;
import org.robotframework.org.netbeans.jemmy.drivers.FrameDriver;
import org.robotframework.org.netbeans.jemmy.drivers.InputDriverInstaller;
import org.robotframework.org.netbeans.jemmy.drivers.InternalFrameDriver;
import org.robotframework.org.netbeans.jemmy.drivers.KeyDriver;
import org.robotframework.org.netbeans.jemmy.drivers.LightDriver;
import org.robotframework.org.netbeans.jemmy.drivers.ListDriver;
import org.robotframework.org.netbeans.jemmy.drivers.MenuDriver;
import org.robotframework.org.netbeans.jemmy.drivers.MouseDriver;
import org.robotframework.org.netbeans.jemmy.drivers.MultiSelListDriver;
import org.robotframework.org.netbeans.jemmy.drivers.OrderedListDriver;
import org.robotframework.org.netbeans.jemmy.drivers.ScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.TableDriver;
import org.robotframework.org.netbeans.jemmy.drivers.TextDriver;
import org.robotframework.org.netbeans.jemmy.drivers.TreeDriver;
import org.robotframework.org.netbeans.jemmy.drivers.WindowDriver;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;

public class DriverManager {
    public static final String DRIVER_ID = "drivers.";
    public static final String TREE_DRIVER_ID = "drivers.tree";
    public static final String TEXT_DRIVER_ID = "drivers.text";
    public static final String KEY_DRIVER_ID = "drivers.key";
    public static final String MOUSE_DRIVER_ID = "drivers.mouse";
    public static final String SCROLL_DRIVER_ID = "drivers.scroll";
    public static final String BUTTON_DRIVER_ID = "drivers.button";
    public static final String LIST_DRIVER_ID = "drivers.list";
    public static final String MULTISELLIST_DRIVER_ID = "drivers.multisellist";
    public static final String ORDEREDLIST_DRIVER_ID = "drivers.orderedlist";
    public static final String TABLE_DRIVER_ID = "drivers.table";
    public static final String WINDOW_DRIVER_ID = "drivers.window";
    public static final String FRAME_DRIVER_ID = "drivers.frame";
    public static final String INTERNAL_FRAME_DRIVER_ID = "drivers.internal_frame";
    public static final String FOCUS_DRIVER_ID = "drivers.focus";
    public static final String MENU_DRIVER_ID = "drivers.menu";
    static /* synthetic */ Class class$org$netbeans$jemmy$operators$ComponentOperator;

    private DriverManager() {
    }

    public static Object getDriver(String id, Class operatorClass, JemmyProperties props) {
        Object result = DriverManager.getADriver(id, operatorClass, props);
        if (result == null) {
            return DriverManager.getDriver(id, operatorClass);
        }
        return result;
    }

    public static Object getDriver(String id, ComponentOperator operator) {
        return DriverManager.getDriver(id, operator.getClass(), operator.getProperties());
    }

    public static Object getDriver(String id, Class operatorClass) {
        Object result = DriverManager.getADriver(id, operatorClass, JemmyProperties.getProperties());
        if (result == null) {
            throw new JemmyException("No \"" + id + "\" driver registered for " + operatorClass.getName() + " class!");
        }
        return result;
    }

    public static void setDriver(String id, Object driver, Class operatorClass) {
        JemmyProperties.setCurrentProperty(DriverManager.makeID(id, operatorClass), driver);
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Installing " + driver.getClass().getName() + " drifer for " + operatorClass.getName() + " operators.");
        }
    }

    public static void setDriver(String id, Object driver, String operatorClassName) {
        JemmyProperties.setCurrentProperty(DriverManager.makeID(id, operatorClassName), driver);
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Installing " + driver.getClass().getName() + " drifer for " + operatorClassName + " operators.");
        }
    }

    public static void setDriver(String id, Driver driver) {
        Class[] supported = driver.getSupported();
        for (int i = 0; i < supported.length; ++i) {
            DriverManager.setDriver(id, (Object)driver, supported[i]);
        }
    }

    public static void setDriver(String id, LightDriver driver) {
        String[] supported = driver.getSupported();
        for (int i = 0; i < supported.length; ++i) {
            DriverManager.setDriver(id, (Object)driver, supported[i]);
        }
    }

    public static void removeDriver(String id, Class operatorClass) {
        JemmyProperties.removeCurrentProperty(DriverManager.makeID(id, operatorClass));
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Uninstalling a drifer for " + operatorClass.getName() + " operators.");
        }
    }

    public static void removeDriver(String id, String operatorClassName) {
        JemmyProperties.removeCurrentProperty(DriverManager.makeID(id, operatorClassName));
        if (Boolean.getBoolean("drivers.trace_output")) {
            JemmyProperties.getCurrentOutput().printLine("Uninstalling a drifer for " + operatorClassName + " operators.");
        }
    }

    public static void removeDriver(String id, Class[] operatorClasses) {
        for (int i = 0; i < operatorClasses.length; ++i) {
            DriverManager.removeDriver(id, operatorClasses[i]);
        }
    }

    public static void removeDriver(String id, String[] operatorClassNames) {
        for (int i = 0; i < operatorClassNames.length; ++i) {
            DriverManager.removeDriver(id, operatorClassNames[i]);
        }
    }

    public static void removeDrivers(String id) {
        String[] keys = JemmyProperties.getCurrentKeys();
        for (int i = 0; i < keys.length; ++i) {
            if (!keys[i].startsWith(id)) continue;
            JemmyProperties.removeCurrentProperty(keys[i]);
        }
    }

    public static TreeDriver getTreeDriver(Class operatorClass) {
        return (TreeDriver)DriverManager.getDriver(TREE_DRIVER_ID, operatorClass);
    }

    public static TreeDriver getTreeDriver(ComponentOperator operator) {
        return (TreeDriver)DriverManager.getDriver(TREE_DRIVER_ID, operator.getClass());
    }

    public static void setTreeDriver(TreeDriver driver) {
        DriverManager.setDriver(TREE_DRIVER_ID, driver);
    }

    public static TextDriver getTextDriver(Class operatorClass) {
        return (TextDriver)DriverManager.getDriver(TEXT_DRIVER_ID, operatorClass);
    }

    public static TextDriver getTextDriver(ComponentOperator operator) {
        return (TextDriver)DriverManager.getDriver(TEXT_DRIVER_ID, operator.getClass());
    }

    public static void setTextDriver(TextDriver driver) {
        DriverManager.setDriver(TEXT_DRIVER_ID, driver);
    }

    public static KeyDriver getKeyDriver(Class operatorClass) {
        return (KeyDriver)DriverManager.getDriver(KEY_DRIVER_ID, operatorClass);
    }

    public static KeyDriver getKeyDriver(ComponentOperator operator) {
        return (KeyDriver)DriverManager.getDriver(KEY_DRIVER_ID, operator.getClass());
    }

    public static void setKeyDriver(KeyDriver driver) {
        DriverManager.setDriver(KEY_DRIVER_ID, driver);
    }

    public static MouseDriver getMouseDriver(Class operatorClass) {
        return (MouseDriver)DriverManager.getDriver(MOUSE_DRIVER_ID, operatorClass);
    }

    public static MouseDriver getMouseDriver(ComponentOperator operator) {
        return (MouseDriver)DriverManager.getDriver(MOUSE_DRIVER_ID, operator.getClass());
    }

    public static void setMouseDriver(MouseDriver driver) {
        DriverManager.setDriver(MOUSE_DRIVER_ID, driver);
    }

    public static ScrollDriver getScrollDriver(Class operatorClass) {
        return (ScrollDriver)DriverManager.getDriver(SCROLL_DRIVER_ID, operatorClass);
    }

    public static ScrollDriver getScrollDriver(ComponentOperator operator) {
        return (ScrollDriver)DriverManager.getDriver(SCROLL_DRIVER_ID, operator.getClass());
    }

    public static void setScrollDriver(ScrollDriver driver) {
        DriverManager.setDriver(SCROLL_DRIVER_ID, driver);
    }

    public static ButtonDriver getButtonDriver(Class operatorClass) {
        return (ButtonDriver)DriverManager.getDriver(BUTTON_DRIVER_ID, operatorClass);
    }

    public static ButtonDriver getButtonDriver(ComponentOperator operator) {
        return (ButtonDriver)DriverManager.getDriver(BUTTON_DRIVER_ID, operator.getClass());
    }

    public static void setButtonDriver(ButtonDriver driver) {
        DriverManager.setDriver(BUTTON_DRIVER_ID, driver);
    }

    public static ListDriver getListDriver(Class operatorClass) {
        return (ListDriver)DriverManager.getDriver(LIST_DRIVER_ID, operatorClass);
    }

    public static ListDriver getListDriver(ComponentOperator operator) {
        return (ListDriver)DriverManager.getDriver(LIST_DRIVER_ID, operator.getClass());
    }

    public static void setListDriver(ListDriver driver) {
        DriverManager.setDriver(LIST_DRIVER_ID, driver);
    }

    public static MultiSelListDriver getMultiSelListDriver(Class operatorClass) {
        return (MultiSelListDriver)DriverManager.getDriver(MULTISELLIST_DRIVER_ID, operatorClass);
    }

    public static MultiSelListDriver getMultiSelListDriver(ComponentOperator operator) {
        return (MultiSelListDriver)DriverManager.getDriver(MULTISELLIST_DRIVER_ID, operator.getClass());
    }

    public static void setMultiSelListDriver(MultiSelListDriver driver) {
        DriverManager.setDriver(MULTISELLIST_DRIVER_ID, driver);
    }

    public static OrderedListDriver getOrderedListDriver(Class operatorClass) {
        return (OrderedListDriver)DriverManager.getDriver(ORDEREDLIST_DRIVER_ID, operatorClass);
    }

    public static OrderedListDriver getOrderedListDriver(ComponentOperator operator) {
        return (OrderedListDriver)DriverManager.getDriver(ORDEREDLIST_DRIVER_ID, operator.getClass());
    }

    public static void setOrderedListDriver(OrderedListDriver driver) {
        DriverManager.setDriver(ORDEREDLIST_DRIVER_ID, driver);
    }

    public static TableDriver getTableDriver(Class operatorClass) {
        return (TableDriver)DriverManager.getDriver(TABLE_DRIVER_ID, operatorClass);
    }

    public static TableDriver getTableDriver(ComponentOperator operator) {
        return (TableDriver)DriverManager.getDriver(TABLE_DRIVER_ID, operator.getClass());
    }

    public static void setTableDriver(TableDriver driver) {
        DriverManager.setDriver(TABLE_DRIVER_ID, driver);
    }

    public static WindowDriver getWindowDriver(Class operatorClass) {
        return (WindowDriver)DriverManager.getDriver(WINDOW_DRIVER_ID, operatorClass);
    }

    public static WindowDriver getWindowDriver(ComponentOperator operator) {
        return (WindowDriver)DriverManager.getDriver(WINDOW_DRIVER_ID, operator.getClass());
    }

    public static void setWindowDriver(WindowDriver driver) {
        DriverManager.setDriver(WINDOW_DRIVER_ID, driver);
    }

    public static FrameDriver getFrameDriver(Class operatorClass) {
        return (FrameDriver)DriverManager.getDriver(FRAME_DRIVER_ID, operatorClass);
    }

    public static FrameDriver getFrameDriver(ComponentOperator operator) {
        return (FrameDriver)DriverManager.getDriver(FRAME_DRIVER_ID, operator.getClass());
    }

    public static void setFrameDriver(FrameDriver driver) {
        DriverManager.setDriver(FRAME_DRIVER_ID, driver);
    }

    public static InternalFrameDriver getInternalFrameDriver(Class operatorClass) {
        return (InternalFrameDriver)DriverManager.getDriver(INTERNAL_FRAME_DRIVER_ID, operatorClass);
    }

    public static InternalFrameDriver getInternalFrameDriver(ComponentOperator operator) {
        return (InternalFrameDriver)DriverManager.getDriver(INTERNAL_FRAME_DRIVER_ID, operator.getClass());
    }

    public static void setInternalFrameDriver(InternalFrameDriver driver) {
        DriverManager.setDriver(INTERNAL_FRAME_DRIVER_ID, driver);
    }

    public static FocusDriver getFocusDriver(Class operatorClass) {
        return (FocusDriver)DriverManager.getDriver(FOCUS_DRIVER_ID, operatorClass);
    }

    public static FocusDriver getFocusDriver(ComponentOperator operator) {
        return (FocusDriver)DriverManager.getDriver(FOCUS_DRIVER_ID, operator.getClass());
    }

    public static void setFocusDriver(FocusDriver driver) {
        DriverManager.setDriver(FOCUS_DRIVER_ID, driver);
    }

    public static MenuDriver getMenuDriver(Class operatorClass) {
        return (MenuDriver)DriverManager.getDriver(MENU_DRIVER_ID, operatorClass);
    }

    public static MenuDriver getMenuDriver(ComponentOperator operator) {
        return (MenuDriver)DriverManager.getDriver(MENU_DRIVER_ID, operator.getClass());
    }

    public static void setMenuDriver(MenuDriver driver) {
        DriverManager.setDriver(MENU_DRIVER_ID, driver);
    }

    static void setDriver(String id, Object driver) {
        if (driver instanceof Driver) {
            DriverManager.setDriver(id, (Driver)driver);
        } else if (driver instanceof LightDriver) {
            DriverManager.setDriver(id, (LightDriver)driver);
        } else {
            throw new JemmyException("Driver is neither Driver nor LightDriver " + driver.toString());
        }
    }

    private static String makeID(String id, Class operatorClass) {
        return DriverManager.makeID(id, operatorClass.getName());
    }

    private static String makeID(String id, String operatorClassName) {
        return id + "." + operatorClassName;
    }

    private static Object getADriver(String id, Class operatorClass, JemmyProperties props) {
        Class superClass = operatorClass;
        do {
            Object drvr;
            if ((drvr = props.getProperty(DriverManager.makeID(id, superClass))) == null) continue;
            return drvr;
        } while ((class$org$netbeans$jemmy$operators$ComponentOperator == null ? DriverManager.class$("org.robotframework.org.netbeans.jemmy.operators.ComponentOperator") : class$org$netbeans$jemmy$operators$ComponentOperator).isAssignableFrom(superClass = superClass.getSuperclass()));
        return null;
    }

    static {
        new InputDriverInstaller().install();
        new DefaultDriverInstaller().install();
    }
}

