/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers;

import org.robotframework.org.netbeans.jemmy.EventDispatcher;
import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.input.KeyEventDriver;
import org.robotframework.org.netbeans.jemmy.drivers.input.KeyRobotDriver;
import org.robotframework.org.netbeans.jemmy.drivers.input.MouseEventDriver;
import org.robotframework.org.netbeans.jemmy.drivers.input.MouseRobotDriver;

public class InputDriverInstaller {
    Timeout robotAutoDelay;
    boolean useEventDrivers;
    boolean smooth = false;

    public InputDriverInstaller(boolean useEventDrivers, Timeout robotAutoDelay) {
        this.robotAutoDelay = robotAutoDelay;
        this.useEventDrivers = useEventDrivers;
    }

    public InputDriverInstaller(boolean useEventDrivers) {
        this(useEventDrivers, JemmyProperties.getCurrentTimeouts().create("EventDispatcher.RobotAutoDelay"));
    }

    public InputDriverInstaller(boolean useEventDrivers, boolean smooth) {
        this(useEventDrivers);
        this.smooth = smooth;
    }

    public InputDriverInstaller(Timeout robotAutoDelay) {
        this(true, robotAutoDelay);
    }

    public InputDriverInstaller() {
        this(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void install() {
        if (this.useEventDrivers) {
            KeyEventDriver keyE = new KeyEventDriver();
            MouseEventDriver mouseE = new MouseEventDriver();
            DriverManager.removeDriver("drivers.key", keyE.getSupported());
            DriverManager.removeDriver("drivers.mouse", mouseE.getSupported());
            DriverManager.setDriver("drivers.key", keyE);
            DriverManager.setDriver("drivers.mouse", mouseE);
            try {
                String[] awtOperators = new String[]{"org.robotframework.org.netbeans.jemmy.operators.ButtonOperator", "org.robotframework.org.netbeans.jemmy.operators.CheckboxOperator", "org.robotframework.org.netbeans.jemmy.operators.ChoiceOperator", "org.robotframework.org.netbeans.jemmy.operators.LabelOperator", "org.robotframework.org.netbeans.jemmy.operators.ListOperator", "org.robotframework.org.netbeans.jemmy.operators.ScrollPaneOperator", "org.robotframework.org.netbeans.jemmy.operators.ScrollbarOperator", "org.robotframework.org.netbeans.jemmy.operators.TextAreaOperator", "org.robotframework.org.netbeans.jemmy.operators.TextComponentOperator", "org.robotframework.org.netbeans.jemmy.operators.TextFieldOperator"};
                KeyRobotDriver keyR = new KeyRobotDriver(this.robotAutoDelay, awtOperators);
                MouseRobotDriver mouseR = new MouseRobotDriver(this.robotAutoDelay, awtOperators);
                DriverManager.removeDriver("drivers.key", keyR.getSupported());
                DriverManager.removeDriver("drivers.mouse", mouseR.getSupported());
                DriverManager.setDriver("drivers.key", keyR);
                DriverManager.setDriver("drivers.mouse", mouseR);
                return;
            }
            catch (JemmyException e) {
                if (e.getInnerException() instanceof ClassNotFoundException) return;
                throw e;
            }
        } else {
            KeyRobotDriver keyR = new KeyRobotDriver(this.robotAutoDelay);
            MouseRobotDriver mouseR = new MouseRobotDriver(this.robotAutoDelay, this.smooth);
            DriverManager.removeDriver("drivers.key", keyR.getSupported());
            DriverManager.removeDriver("drivers.mouse", mouseR.getSupported());
            DriverManager.setDriver("drivers.key", keyR);
            DriverManager.setDriver("drivers.mouse", mouseR);
        }
    }

    static {
        Class clazz = EventDispatcher.class;
    }
}

