/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.robotframework.org.netbeans.jemmy.QueueTool;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.MouseDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JButtonOperator;
import org.robotframework.org.netbeans.jemmy.operators.JScrollBarOperator;

public class JScrollBarDriver
extends AbstractScrollDriver {
    private static final int SMALL_INCREMENT = 1;
    private static final int MINIMAL_DRAGGER_SIZE = 5;
    private static final int RELATIVE_DRAG_STEP_LENGTH = 20;
    private QueueTool queueTool = new QueueTool();

    public JScrollBarDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.JScrollBarOperator"});
    }

    public void scrollToMinimum(ComponentOperator oper, int orientation) {
        this.startDragging(oper);
        Point pnt = new Point(0, 0);
        this.drag(oper, pnt);
        Timeout sleepTime = oper.getTimeouts().create("Waiter.TimeDelta");
        while (((JScrollBarOperator)oper).getValue() > ((JScrollBarOperator)oper).getMinimum()) {
            sleepTime.sleep();
        }
        this.drop(oper, pnt);
    }

    public void scrollToMaximum(ComponentOperator oper, int orientation) {
        this.startDragging(oper);
        Point pnt = new Point(oper.getWidth() - 1, oper.getHeight() - 1);
        this.drag(oper, pnt);
        Timeout sleepTime = oper.getTimeouts().create("Waiter.TimeDelta");
        while (((JScrollBarOperator)oper).getValue() > ((JScrollBarOperator)oper).getMaximum() - ((JScrollBarOperator)oper).getVisibleAmount()) {
            sleepTime.sleep();
        }
        this.drop(oper, pnt);
    }

    protected void step(ComponentOperator oper, ScrollAdjuster adj) {
        JButtonOperator boper = this.findAButton(oper, adj.getScrollDirection());
        DriverManager.getButtonDriver(boper).push(boper);
    }

    protected void jump(final ComponentOperator oper, final ScrollAdjuster adj) {
        final JButtonOperator lessButton = this.findAButton(oper, -1);
        final JButtonOperator moreButton = this.findAButton(oper, 1);
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

            public Object launch() {
                if (adj.getScrollDirection() != 0) {
                    int y;
                    int x;
                    if (((JScrollBarOperator)oper).getOrientation() == 0) {
                        if (adj.getScrollDirection() == 1) {
                            x = moreButton.getX() - 1;
                        } else if (adj.getScrollDirection() == -1) {
                            x = lessButton.getX() + lessButton.getWidth();
                        } else {
                            return null;
                        }
                        y = lessButton.getHeight() / 2;
                    } else if (((JScrollBarOperator)oper).getOrientation() == 1) {
                        if (adj.getScrollDirection() == 1) {
                            y = moreButton.getY() - 1;
                        } else if (adj.getScrollDirection() == -1) {
                            y = lessButton.getY() + lessButton.getHeight();
                        } else {
                            return null;
                        }
                        x = lessButton.getWidth() / 2;
                    } else {
                        return null;
                    }
                    1 v0 = this;
                    DriverManager.getMouseDriver(oper).clickMouse(oper, x, y, 1, v0.oper.getDefaultMouseButton(), 0, new Timeout("", 0L));
                }
                return null;
            }
        });
    }

    protected void startPushAndWait(ComponentOperator oper, int direction, int orientation) {
        JButtonOperator boper = this.findAButton(oper, direction);
        DriverManager.getButtonDriver(boper).press(boper);
    }

    protected void stopPushAndWait(ComponentOperator oper, int direction, int orientation) {
        JButtonOperator boper = this.findAButton(oper, direction);
        DriverManager.getButtonDriver(boper).release(boper);
    }

    protected Point startDragging(ComponentOperator oper) {
        JButtonOperator lessButton = this.findAButton(oper, -1);
        JButtonOperator moreButton = this.findAButton(oper, 1);
        Point pnt = this.getClickPoint((JScrollBarOperator)oper, lessButton, moreButton, ((JScrollBarOperator)oper).getValue());
        MouseDriver mdriver = DriverManager.getMouseDriver(oper);
        mdriver.moveMouse(oper, pnt.x, pnt.y);
        mdriver.pressMouse(oper, pnt.x, pnt.y, oper.getDefaultMouseButton(), 0);
        return pnt;
    }

    protected void drop(ComponentOperator oper, Point pnt) {
        DriverManager.getMouseDriver(oper).releaseMouse(oper, pnt.x, pnt.y, oper.getDefaultMouseButton(), 0);
    }

    protected void drag(ComponentOperator oper, Point pnt) {
        DriverManager.getMouseDriver(oper).dragMouse(oper, pnt.x, pnt.y, oper.getDefaultMouseButton(), 0);
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator oper) {
        return oper.getTimeouts().create("ScrollbarOperator.DragAndDropScrollingDelta");
    }

    protected boolean canDragAndDrop(ComponentOperator oper) {
        if (!this.isSmallIncrement((JScrollBarOperator)oper)) {
            return false;
        }
        boolean result = false;
        MouseDriver mdriver = DriverManager.getMouseDriver(oper);
        JButtonOperator less = this.findAButton(oper, -1);
        JButtonOperator more = this.findAButton(oper, 1);
        Point pnt = this.getClickPoint((JScrollBarOperator)oper, less, more, ((JScrollBarOperator)oper).getValue());
        mdriver.moveMouse(oper, pnt.x, pnt.y);
        mdriver.pressMouse(oper, pnt.x, pnt.y, oper.getDefaultMouseButton(), 0);
        result = ((JScrollBarOperator)oper).getValueIsAdjusting();
        mdriver.releaseMouse(oper, pnt.x, pnt.y, oper.getDefaultMouseButton(), 0);
        return result && this.isSmallIncrement((JScrollBarOperator)oper);
    }

    protected boolean canJump(ComponentOperator oper) {
        return this.isSmallIncrement((JScrollBarOperator)oper);
    }

    protected boolean canPushAndWait(ComponentOperator oper) {
        return this.isSmallIncrement((JScrollBarOperator)oper);
    }

    protected int getDragAndDropStepLength(ComponentOperator oper) {
        int height;
        int max;
        JButtonOperator less = this.findAButton(oper, -1);
        JButtonOperator more = this.findAButton(oper, 1);
        int width = oper.getWidth() - less.getWidth() - more.getWidth();
        int n = max = width > (height = oper.getHeight() - less.getHeight() - more.getHeight()) ? width : height;
        if (max >= 40) {
            return max / 20;
        }
        return 1;
    }

    private boolean isSmallIncrement(JScrollBarOperator oper) {
        return oper.getUnitIncrement(-1) <= 1 && oper.getUnitIncrement(1) <= 1;
    }

    private Point getClickPoint(JScrollBarOperator oper, JButtonOperator lessButton, JButtonOperator moreButton, int value) {
        int lenght = oper.getOrientation() == 0 ? oper.getWidth() - lessButton.getWidth() - moreButton.getWidth() : oper.getHeight() - lessButton.getHeight() - moreButton.getHeight();
        int subpos = (int)((float)lenght / (float)(oper.getMaximum() - oper.getMinimum()) * (float)value);
        subpos = oper.getOrientation() == 0 ? (subpos += lessButton.getWidth()) : (subpos += lessButton.getHeight());
        subpos = subpos + 2 + 1;
        return oper.getOrientation() == 0 ? new Point(subpos, oper.getHeight() / 2) : new Point(oper.getWidth() / 2, subpos);
    }

    private JButtonOperator findAButton(ComponentOperator oper, int direction) {
        return direction == -1 ? ((JScrollBarOperator)oper).getDecreaseButton() : ((JScrollBarOperator)oper).getIncreaseButton();
    }
}

