/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.robotframework.org.netbeans.jemmy.QueueTool;
import org.robotframework.org.netbeans.jemmy.Timeout;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.MouseDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.AbstractScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JSliderOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;

public class JSliderDriver
extends AbstractScrollDriver {
    private QueueTool queueTool = new QueueTool();

    public JSliderDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.JSliderOperator"});
    }

    public void scrollToMinimum(final ComponentOperator oper, int orientation) {
        this.checkSupported(oper);
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollDirection() {
                return ((JSliderOperator)oper).getMinimum() < ((JSliderOperator)oper).getValue() ? -1 : 0;
            }

            public int getScrollOrientation() {
                return ((JSliderOperator)oper).getOrientation();
            }

            public String getDescription() {
                return "Scroll to minimum";
            }
        });
    }

    public void scrollToMaximum(final ComponentOperator oper, int orientation) {
        this.checkSupported(oper);
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollDirection() {
                return ((JSliderOperator)oper).getMaximum() > ((JSliderOperator)oper).getValue() ? 1 : 0;
            }

            public int getScrollOrientation() {
                return ((JSliderOperator)oper).getOrientation();
            }

            public String getDescription() {
                return "Scroll to maximum";
            }
        });
    }

    protected void step(final ComponentOperator oper, final ScrollAdjuster adj) {
        if (adj.getScrollDirection() != 0) {
            this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Choise expanding"){

                public Object launch() {
                    Point clickPoint = JSliderDriver.this.getClickPoint(oper, adj.getScrollDirection(), adj.getScrollOrientation());
                    if (clickPoint != null) {
                        DriverManager.getMouseDriver(oper).clickMouse(oper, clickPoint.x, clickPoint.y, 1, Operator.getDefaultMouseButton(), 0, oper.getTimeouts().create("ComponentOperator.MouseClickTimeout"));
                    }
                    return null;
                }
            });
        }
    }

    protected void jump(ComponentOperator oper, ScrollAdjuster adj) {
    }

    protected void startPushAndWait(final ComponentOperator oper, final int direction, final int orientation) {
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Start scrolling"){

            public Object launch() {
                Point clickPoint = JSliderDriver.this.getClickPoint(oper, direction, orientation);
                if (clickPoint != null) {
                    MouseDriver mdriver = DriverManager.getMouseDriver(oper);
                    mdriver.moveMouse(oper, clickPoint.x, clickPoint.y);
                    mdriver.pressMouse(oper, clickPoint.x, clickPoint.y, Operator.getDefaultMouseButton(), 0);
                }
                return null;
            }
        });
    }

    protected void stopPushAndWait(final ComponentOperator oper, final int direction, final int orientation) {
        this.queueTool.invokeSmoothly(new QueueTool.QueueAction("Stop scrolling"){

            public Object launch() {
                Point clickPoint = JSliderDriver.this.getClickPoint(oper, direction, orientation);
                if (clickPoint != null) {
                    MouseDriver mdriver = DriverManager.getMouseDriver(oper);
                    mdriver.releaseMouse(oper, clickPoint.x, clickPoint.y, Operator.getDefaultMouseButton(), 0);
                }
                return null;
            }
        });
    }

    protected Point startDragging(ComponentOperator oper) {
        return null;
    }

    protected void drop(ComponentOperator oper, Point pnt) {
    }

    protected void drag(ComponentOperator oper, Point pnt) {
    }

    protected Timeout getScrollDeltaTimeout(ComponentOperator oper) {
        return oper.getTimeouts().create("JSliderOperator.ScrollingDelta");
    }

    protected boolean canDragAndDrop(ComponentOperator oper) {
        return false;
    }

    protected boolean canJump(ComponentOperator oper) {
        return false;
    }

    protected boolean canPushAndWait(ComponentOperator oper) {
        return true;
    }

    protected int getDragAndDropStepLength(ComponentOperator oper) {
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Point getClickPoint(ComponentOperator oper, int direction, int orientation) {
        int y;
        int x;
        boolean inverted = ((JSliderOperator)oper).getInverted();
        int realDirection = 0;
        if (inverted) {
            if (direction == 1) {
                realDirection = -1;
            } else {
                if (direction != -1) return null;
                realDirection = 1;
            }
        } else {
            realDirection = direction;
        }
        if (orientation == 0) {
            if (realDirection == 1) {
                x = oper.getWidth() - 1;
            } else {
                if (realDirection != -1) return null;
                x = 0;
            }
            y = oper.getHeight() / 2;
            return new Point(x, y);
        } else {
            if (orientation != 1) return null;
            if (realDirection == 1) {
                y = 0;
            } else {
                if (realDirection != -1) return null;
                y = oper.getHeight() - 1;
            }
            x = oper.getWidth() / 2;
        }
        return new Point(x, y);
    }
}

