/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ButtonUI;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.TestOut;
import org.robotframework.org.netbeans.jemmy.Timeoutable;
import org.robotframework.org.netbeans.jemmy.Timeouts;
import org.robotframework.org.netbeans.jemmy.drivers.ButtonDriver;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;

public class AbstractButtonOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    public static final String IS_SELECTED_DPROP = "Selected";
    private static final long PUSH_BUTTON_TIMEOUT = 0L;
    private Timeouts timeouts;
    private TestOut output;
    ButtonDriver driver = DriverManager.getButtonDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$AbstractButton;

    public AbstractButtonOperator(AbstractButton b) {
        super(b);
    }

    public AbstractButtonOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((AbstractButton)cont.waitSubComponent(new AbstractButtonFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public AbstractButtonOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public AbstractButtonOperator(ContainerOperator cont, String text, int index) {
        this((AbstractButton)AbstractButtonOperator.waitComponent(cont, (ComponentChooser)new AbstractButtonByLabelFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public AbstractButtonOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public AbstractButtonOperator(ContainerOperator cont, int index) {
        this((AbstractButton)AbstractButtonOperator.waitComponent(cont, (ComponentChooser)new AbstractButtonFinder(), index));
        this.copyEnvironment(cont);
    }

    public AbstractButtonOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static AbstractButton findAbstractButton(Container cont, ComponentChooser chooser, int index) {
        return (AbstractButton)AbstractButtonOperator.findComponent(cont, new AbstractButtonFinder(chooser), index);
    }

    public static AbstractButton findAbstractButton(Container cont, ComponentChooser chooser) {
        return AbstractButtonOperator.findAbstractButton(cont, chooser, 0);
    }

    public static AbstractButton findAbstractButton(Container cont, String text, boolean ce, boolean ccs, int index) {
        return AbstractButtonOperator.findAbstractButton(cont, new AbstractButtonByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static AbstractButton findAbstractButton(Container cont, String text, boolean ce, boolean ccs) {
        return AbstractButtonOperator.findAbstractButton(cont, text, ce, ccs, 0);
    }

    public static AbstractButton waitAbstractButton(Container cont, ComponentChooser chooser, int index) {
        return (AbstractButton)AbstractButtonOperator.waitComponent(cont, (ComponentChooser)new AbstractButtonFinder(chooser), index);
    }

    public static AbstractButton waitAbstractButton(Container cont, ComponentChooser chooser) {
        return AbstractButtonOperator.waitAbstractButton(cont, chooser, 0);
    }

    public static AbstractButton waitAbstractButton(Container cont, String text, boolean ce, boolean ccs, int index) {
        return AbstractButtonOperator.waitAbstractButton(cont, new AbstractButtonByLabelFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static AbstractButton waitAbstractButton(Container cont, String text, boolean ce, boolean ccs) {
        return AbstractButtonOperator.waitAbstractButton(cont, text, ce, ccs, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = DriverManager.getButtonDriver(this);
    }

    public void push() {
        this.output.printLine("Push button\n    :" + this.toStringSource());
        this.output.printGolden("Push button");
        this.makeComponentVisible();
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted", e);
        }
        this.driver.push(this);
    }

    public void pushNoBlock() {
        this.produceNoBlocking(new Operator.NoBlockingAction("Button pushing"){

            public Object doAction(Object param) {
                AbstractButtonOperator.this.push();
                return null;
            }
        });
    }

    public void changeSelection(boolean selected) {
        if (this.isSelected() != selected) {
            this.push();
        }
        if (this.getVerification()) {
            this.waitSelected(selected);
        }
    }

    public void changeSelectionNoBlock(boolean selected) {
        this.produceNoBlocking(new Operator.NoBlockingAction("Button selection changing"){

            public Object doAction(Object param) {
                AbstractButtonOperator.this.changeSelection((Boolean)param);
                return null;
            }
        }, selected ? Boolean.TRUE : Boolean.FALSE);
    }

    public void press() {
        this.output.printLine("Press button\n    :" + this.toStringSource());
        this.output.printGolden("Press button");
        this.makeComponentVisible();
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted", e);
        }
        this.driver.press(this);
    }

    public void release() {
        this.output.printLine("Release button\n    :" + this.toStringSource());
        this.output.printGolden("Release button");
        try {
            this.waitComponentEnabled();
        }
        catch (InterruptedException e) {
            throw new JemmyException("Interrupted", e);
        }
        this.driver.release(this);
    }

    public void waitSelected(final boolean selected) {
        this.getOutput().printLine("Wait button to be selected \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait button to be selected");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return AbstractButtonOperator.this.isSelected() == selected;
            }

            public String getDescription() {
                return "Items has been " + (selected ? "" : "un") + "selected";
            }
        });
    }

    public void waitText(String text) {
        this.getOutput().printLine("Wait \"" + text + "\" text in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + text + "\" text");
        this.waitState(new AbstractButtonByLabelFinder(text, this.getComparator()));
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((AbstractButton)this.getSource()).getText() != null) {
            result.put(TEXT_DPROP, ((AbstractButton)this.getSource()).getText());
        }
        result.put(IS_SELECTED_DPROP, ((AbstractButton)this.getSource()).isSelected() ? "true" : "false");
        return result;
    }

    public void addActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("addActionListener"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).addActionListener(actionListener);
            }
        });
    }

    public void addChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("addChangeListener"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).addChangeListener(changeListener);
            }
        });
    }

    public void addItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("addItemListener"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).addItemListener(itemListener);
            }
        });
    }

    public void doClick() {
        this.runMapping(new Operator.MapVoidAction("doClick"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).doClick();
            }
        });
    }

    public void doClick(final int i) {
        this.runMapping(new Operator.MapVoidAction("doClick"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).doClick(i);
            }
        });
    }

    public String getActionCommand() {
        return (String)this.runMapping(new Operator.MapAction("getActionCommand"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getActionCommand();
            }
        });
    }

    public Icon getDisabledIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getDisabledIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getDisabledIcon();
            }
        });
    }

    public Icon getDisabledSelectedIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getDisabledSelectedIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getDisabledSelectedIcon();
            }
        });
    }

    public int getHorizontalAlignment() {
        return this.runMapping(new Operator.MapIntegerAction("getHorizontalAlignment"){

            public int map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getHorizontalAlignment();
            }
        });
    }

    public int getHorizontalTextPosition() {
        return this.runMapping(new Operator.MapIntegerAction("getHorizontalTextPosition"){

            public int map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getHorizontalTextPosition();
            }
        });
    }

    public Icon getIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getIcon();
            }
        });
    }

    public Insets getMargin() {
        return (Insets)this.runMapping(new Operator.MapAction("getMargin"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getMargin();
            }
        });
    }

    public int getMnemonic() {
        return this.runMapping(new Operator.MapIntegerAction("getMnemonic"){

            public int map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getMnemonic();
            }
        });
    }

    public ButtonModel getModel() {
        return (ButtonModel)this.runMapping(new Operator.MapAction("getModel"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getModel();
            }
        });
    }

    public Icon getPressedIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getPressedIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getPressedIcon();
            }
        });
    }

    public Icon getRolloverIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getRolloverIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getRolloverIcon();
            }
        });
    }

    public Icon getRolloverSelectedIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getRolloverSelectedIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getRolloverSelectedIcon();
            }
        });
    }

    public Icon getSelectedIcon() {
        return (Icon)this.runMapping(new Operator.MapAction("getSelectedIcon"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getSelectedIcon();
            }
        });
    }

    public Object[] getSelectedObjects() {
        return (Object[])this.runMapping(new Operator.MapAction("getSelectedObjects"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getSelectedObjects();
            }
        });
    }

    public String getText() {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getText();
            }
        });
    }

    public ButtonUI getUI() {
        return (ButtonUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getUI();
            }
        });
    }

    public int getVerticalAlignment() {
        return this.runMapping(new Operator.MapIntegerAction("getVerticalAlignment"){

            public int map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getVerticalAlignment();
            }
        });
    }

    public int getVerticalTextPosition() {
        return this.runMapping(new Operator.MapIntegerAction("getVerticalTextPosition"){

            public int map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).getVerticalTextPosition();
            }
        });
    }

    public boolean isBorderPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isBorderPainted"){

            public boolean map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).isBorderPainted();
            }
        });
    }

    public boolean isContentAreaFilled() {
        return this.runMapping(new Operator.MapBooleanAction("isContentAreaFilled"){

            public boolean map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).isContentAreaFilled();
            }
        });
    }

    public boolean isFocusPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isFocusPainted"){

            public boolean map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).isFocusPainted();
            }
        });
    }

    public boolean isRolloverEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isRolloverEnabled"){

            public boolean map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).isRolloverEnabled();
            }
        });
    }

    public boolean isSelected() {
        return this.runMapping(new Operator.MapBooleanAction("isSelected"){

            public boolean map() {
                return ((AbstractButton)AbstractButtonOperator.this.getSource()).isSelected();
            }
        });
    }

    public void removeActionListener(final ActionListener actionListener) {
        this.runMapping(new Operator.MapVoidAction("removeActionListener"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).removeActionListener(actionListener);
            }
        });
    }

    public void removeChangeListener(final ChangeListener changeListener) {
        this.runMapping(new Operator.MapVoidAction("removeChangeListener"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).removeChangeListener(changeListener);
            }
        });
    }

    public void removeItemListener(final ItemListener itemListener) {
        this.runMapping(new Operator.MapVoidAction("removeItemListener"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).removeItemListener(itemListener);
            }
        });
    }

    public void setActionCommand(final String string) {
        this.runMapping(new Operator.MapVoidAction("setActionCommand"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setActionCommand(string);
            }
        });
    }

    public void setBorderPainted(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setBorderPainted"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setBorderPainted(b);
            }
        });
    }

    public void setContentAreaFilled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setContentAreaFilled"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setContentAreaFilled(b);
            }
        });
    }

    public void setDisabledIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setDisabledIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setDisabledIcon(icon);
            }
        });
    }

    public void setDisabledSelectedIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setDisabledSelectedIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setDisabledSelectedIcon(icon);
            }
        });
    }

    public void setFocusPainted(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setFocusPainted"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setFocusPainted(b);
            }
        });
    }

    public void setHorizontalAlignment(final int i) {
        this.runMapping(new Operator.MapVoidAction("setHorizontalAlignment"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setHorizontalAlignment(i);
            }
        });
    }

    public void setHorizontalTextPosition(final int i) {
        this.runMapping(new Operator.MapVoidAction("setHorizontalTextPosition"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setHorizontalTextPosition(i);
            }
        });
    }

    public void setIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setIcon(icon);
            }
        });
    }

    public void setMargin(final Insets insets) {
        this.runMapping(new Operator.MapVoidAction("setMargin"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setMargin(insets);
            }
        });
    }

    public void setMnemonic(final char c) {
        this.runMapping(new Operator.MapVoidAction("setMnemonic"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setMnemonic(c);
            }
        });
    }

    public void setMnemonic(final int i) {
        this.runMapping(new Operator.MapVoidAction("setMnemonic"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setMnemonic(i);
            }
        });
    }

    public void setModel(final ButtonModel buttonModel) {
        this.runMapping(new Operator.MapVoidAction("setModel"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setModel(buttonModel);
            }
        });
    }

    public void setPressedIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setPressedIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setPressedIcon(icon);
            }
        });
    }

    public void setRolloverEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setRolloverEnabled"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setRolloverEnabled(b);
            }
        });
    }

    public void setRolloverIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setRolloverIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setRolloverIcon(icon);
            }
        });
    }

    public void setRolloverSelectedIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setRolloverSelectedIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setRolloverSelectedIcon(icon);
            }
        });
    }

    public void setSelected(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setSelected"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setSelected(b);
            }
        });
    }

    public void setSelectedIcon(final Icon icon) {
        this.runMapping(new Operator.MapVoidAction("setSelectedIcon"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setSelectedIcon(icon);
            }
        });
    }

    public void setText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setText"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setText(string);
            }
        });
    }

    public void setUI(final ButtonUI buttonUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setUI(buttonUI);
            }
        });
    }

    public void setVerticalAlignment(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVerticalAlignment"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setVerticalAlignment(i);
            }
        });
    }

    public void setVerticalTextPosition(final int i) {
        this.runMapping(new Operator.MapVoidAction("setVerticalTextPosition"){

            public void map() {
                ((AbstractButton)AbstractButtonOperator.this.getSource()).setVerticalTextPosition(i);
            }
        });
    }

    static {
        Timeouts.initDefault("AbstractButtonOperator.PushButtonTimeout", 0L);
    }

    public static class AbstractButtonFinder
    extends Operator.Finder {
        public AbstractButtonFinder(ComponentChooser sf) {
            super(class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = AbstractButtonOperator.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton, sf);
        }

        public AbstractButtonFinder() {
            super(class$javax$swing$AbstractButton == null ? (class$javax$swing$AbstractButton = AbstractButtonOperator.class$("javax.swing.AbstractButton")) : class$javax$swing$AbstractButton);
        }
    }

    public static class AbstractButtonByLabelFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public AbstractButtonByLabelFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public AbstractButtonByLabelFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof AbstractButton && ((AbstractButton)comp).getText() != null) {
                return this.comparator.equals(((AbstractButton)comp).getText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "AbstractButton with text \"" + this.label + "\"";
        }
    }
}

