/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.beans.VetoableChangeListener;
import java.util.Hashtable;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.AncestorListener;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.ComponentSearcher;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.TestOut;
import org.robotframework.org.netbeans.jemmy.Timeoutable;
import org.robotframework.org.netbeans.jemmy.Timeouts;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.org.netbeans.jemmy.operators.WindowOperator;

public class JComponentOperator
extends ContainerOperator
implements Timeoutable,
Outputable {
    public static final String TOOLTIP_TEXT_DPROP = "Tooltip text";
    public static final String A11Y_DATA = "Accessible data (yes/no)";
    public static final String A11Y_NAME_DPROP = "Accessible name";
    public static final String A11Y_DESCRIPTION_DPROP = "Accessible decription";
    private static final long WAIT_TOOL_TIP_TIMEOUT = 10000L;
    private static final long SHOW_TOOL_TIP_TIMEOUT = 0L;
    private Timeouts timeouts;
    private TestOut output;
    static /* synthetic */ Class class$javax$swing$JComponent;
    static /* synthetic */ Class class$javax$swing$JToolTip;

    public JComponentOperator(JComponent b) {
        super(b);
    }

    public JComponentOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JComponent)cont.waitSubComponent(new JComponentFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JComponentOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JComponentOperator(ContainerOperator cont, int index) {
        this((JComponent)JComponentOperator.waitComponent(cont, (ComponentChooser)new JComponentFinder(ComponentSearcher.getTrueChooser("Any JComponent")), index));
        this.copyEnvironment(cont);
    }

    public JComponentOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JComponent findJComponent(Container cont, ComponentChooser chooser, int index) {
        return (JComponent)JComponentOperator.findComponent(cont, new JComponentFinder(chooser), index);
    }

    public static JComponent findJComponent(Container cont, ComponentChooser chooser) {
        return JComponentOperator.findJComponent(cont, chooser, 0);
    }

    public static JComponent findJComponent(Container cont, String toolTipText, boolean ce, boolean ccs, int index) {
        return JComponentOperator.findJComponent(cont, new JComponentByTipFinder(toolTipText, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JComponent findJComponent(Container cont, String toolTipText, boolean ce, boolean ccs) {
        return JComponentOperator.findJComponent(cont, toolTipText, ce, ccs, 0);
    }

    public static JComponent waitJComponent(Container cont, ComponentChooser chooser, int index) {
        return (JComponent)JComponentOperator.waitComponent(cont, (ComponentChooser)new JComponentFinder(chooser), index);
    }

    public static JComponent waitJComponent(Container cont, ComponentChooser chooser) {
        return JComponentOperator.waitJComponent(cont, chooser, 0);
    }

    public static JComponent waitJComponent(Container cont, String toolTipText, boolean ce, boolean ccs, int index) {
        return JComponentOperator.waitJComponent(cont, new JComponentByTipFinder(toolTipText, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JComponent waitJComponent(Container cont, String toolTipText, boolean ce, boolean ccs) {
        return JComponentOperator.waitJComponent(cont, toolTipText, ce, ccs, 0);
    }

    public void setTimeouts(Timeouts timeouts) {
        super.setTimeouts(timeouts);
        this.timeouts = timeouts;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public int getCenterXForClick() {
        Rectangle rect = this.getVisibleRect();
        return (int)rect.getX() + (int)rect.getWidth() / 2;
    }

    public int getCenterYForClick() {
        Rectangle rect = this.getVisibleRect();
        return (int)rect.getY() + (int)rect.getHeight() / 2;
    }

    public JToolTip showToolTip() {
        this.enterMouse();
        this.moveMouse(this.getCenterXForClick(), this.getCenterYForClick());
        return this.waitToolTip();
    }

    public JToolTip waitToolTip() {
        return (JToolTip)JComponentOperator.waitComponent(WindowOperator.waitWindow(new JToolTipWindowFinder(), 0, this.getTimeouts(), this.getOutput()), new JToolTipFinder(), 0, this.getTimeouts(), this.getOutput());
    }

    public ContainerOperator getWindowContainerOperator() {
        Component resultComp = this.getSource() instanceof Window ? this.getSource() : this.getContainer(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return comp instanceof Window || comp instanceof JInternalFrame;
            }

            public String getDescription() {
                return "";
            }
        });
        ContainerOperator result = resultComp instanceof Window ? new WindowOperator((Window)resultComp) : new ContainerOperator((Container)resultComp);
        result.copyEnvironment(this);
        return result;
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((JComponent)this.getSource()).getToolTipText() != null) {
            result.put(TOOLTIP_TEXT_DPROP, ((JComponent)this.getSource()).getToolTipText());
        }
        if (System.getProperty("jemmy.dump.a11y") != null && System.getProperty("jemmy.dump.a11y").equals("on")) {
            AccessibleContext a11y = ((JComponent)this.getSource()).getAccessibleContext();
            if (a11y != null) {
                result.put(A11Y_DATA, "yes");
                String accName = a11y.getAccessibleName() == null ? "null" : a11y.getAccessibleName();
                String accDesc = a11y.getAccessibleDescription() == null ? "null" : a11y.getAccessibleDescription();
                result.put(A11Y_NAME_DPROP, accName);
                result.put(A11Y_DESCRIPTION_DPROP, accDesc);
            } else {
                result.put(A11Y_DATA, "no");
            }
        }
        return result;
    }

    public void addAncestorListener(final AncestorListener ancestorListener) {
        this.runMapping(new Operator.MapVoidAction("addAncestorListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).addAncestorListener(ancestorListener);
            }
        });
    }

    public void addVetoableChangeListener(final VetoableChangeListener vetoableChangeListener) {
        this.runMapping(new Operator.MapVoidAction("addVetoableChangeListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).addVetoableChangeListener(vetoableChangeListener);
            }
        });
    }

    public void computeVisibleRect(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("computeVisibleRect"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).computeVisibleRect(rectangle);
            }
        });
    }

    public JToolTip createToolTip() {
        return (JToolTip)this.runMapping(new Operator.MapAction("createToolTip"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).createToolTip();
            }
        });
    }

    public void firePropertyChange(final String string, final byte b, final byte b1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, b, b1);
            }
        });
    }

    public void firePropertyChange(final String string, final char c, final char c1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, c, c1);
            }
        });
    }

    public void firePropertyChange(final String string, final double d, final double d1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, d, d1);
            }
        });
    }

    public void firePropertyChange(final String string, final float f, final float f1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, f, f1);
            }
        });
    }

    public void firePropertyChange(final String string, final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, i, i1);
            }
        });
    }

    public void firePropertyChange(final String string, final long l, final long l1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, l, l1);
            }
        });
    }

    public void firePropertyChange(final String string, final short s, final short s1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, s, s1);
            }
        });
    }

    public void firePropertyChange(final String string, final boolean b, final boolean b1) {
        this.runMapping(new Operator.MapVoidAction("firePropertyChange"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).firePropertyChange(string, b, b1);
            }
        });
    }

    public AccessibleContext getAccessibleContext() {
        return (AccessibleContext)this.runMapping(new Operator.MapAction("getAccessibleContext"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getAccessibleContext();
            }
        });
    }

    public ActionListener getActionForKeyStroke(final KeyStroke keyStroke) {
        return (ActionListener)this.runMapping(new Operator.MapAction("getActionForKeyStroke"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getActionForKeyStroke(keyStroke);
            }
        });
    }

    public boolean getAutoscrolls() {
        return this.runMapping(new Operator.MapBooleanAction("getAutoscrolls"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).getAutoscrolls();
            }
        });
    }

    public Border getBorder() {
        return (Border)this.runMapping(new Operator.MapAction("getBorder"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getBorder();
            }
        });
    }

    public Object getClientProperty(final Object object) {
        return this.runMapping(new Operator.MapAction("getClientProperty"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getClientProperty(object);
            }
        });
    }

    public int getConditionForKeyStroke(final KeyStroke keyStroke) {
        return this.runMapping(new Operator.MapIntegerAction("getConditionForKeyStroke"){

            public int map() {
                return ((JComponent)JComponentOperator.this.getSource()).getConditionForKeyStroke(keyStroke);
            }
        });
    }

    public int getDebugGraphicsOptions() {
        return this.runMapping(new Operator.MapIntegerAction("getDebugGraphicsOptions"){

            public int map() {
                return ((JComponent)JComponentOperator.this.getSource()).getDebugGraphicsOptions();
            }
        });
    }

    public Insets getInsets(final Insets insets) {
        return (Insets)this.runMapping(new Operator.MapAction("getInsets"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getInsets(insets);
            }
        });
    }

    public Component getNextFocusableComponent() {
        return (Component)this.runMapping(new Operator.MapAction("getNextFocusableComponent"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getNextFocusableComponent();
            }
        });
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        return (KeyStroke[])this.runMapping(new Operator.MapAction("getRegisteredKeyStrokes"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getRegisteredKeyStrokes();
            }
        });
    }

    public JRootPane getRootPane() {
        return (JRootPane)this.runMapping(new Operator.MapAction("getRootPane"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getRootPane();
            }
        });
    }

    public Point getToolTipLocation(final MouseEvent mouseEvent) {
        return (Point)this.runMapping(new Operator.MapAction("getToolTipLocation"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getToolTipLocation(mouseEvent);
            }
        });
    }

    public String getToolTipText() {
        return (String)this.runMapping(new Operator.MapAction("getToolTipText"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getToolTipText();
            }
        });
    }

    public String getToolTipText(final MouseEvent mouseEvent) {
        return (String)this.runMapping(new Operator.MapAction("getToolTipText"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getToolTipText(mouseEvent);
            }
        });
    }

    public Container getTopLevelAncestor() {
        return (Container)this.runMapping(new Operator.MapAction("getTopLevelAncestor"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getTopLevelAncestor();
            }
        });
    }

    public String getUIClassID() {
        return (String)this.runMapping(new Operator.MapAction("getUIClassID"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getUIClassID();
            }
        });
    }

    public Rectangle getVisibleRect() {
        return (Rectangle)this.runMapping(new Operator.MapAction("getVisibleRect"){

            public Object map() {
                return ((JComponent)JComponentOperator.this.getSource()).getVisibleRect();
            }
        });
    }

    public void grabFocus() {
        this.runMapping(new Operator.MapVoidAction("grabFocus"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).grabFocus();
            }
        });
    }

    public boolean isFocusCycleRoot() {
        return this.runMapping(new Operator.MapBooleanAction("isFocusCycleRoot"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isFocusCycleRoot();
            }
        });
    }

    public boolean isManagingFocus() {
        return this.runMapping(new Operator.MapBooleanAction("isManagingFocus"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isManagingFocus();
            }
        });
    }

    public boolean isOptimizedDrawingEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isOptimizedDrawingEnabled"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isOptimizedDrawingEnabled();
            }
        });
    }

    public boolean isPaintingTile() {
        return this.runMapping(new Operator.MapBooleanAction("isPaintingTile"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isPaintingTile();
            }
        });
    }

    public boolean isRequestFocusEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isRequestFocusEnabled"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isRequestFocusEnabled();
            }
        });
    }

    public boolean isValidateRoot() {
        return this.runMapping(new Operator.MapBooleanAction("isValidateRoot"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).isValidateRoot();
            }
        });
    }

    public void paintImmediately(final int i, final int i1, final int i2, final int i3) {
        this.runMapping(new Operator.MapVoidAction("paintImmediately"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).paintImmediately(i, i1, i2, i3);
            }
        });
    }

    public void paintImmediately(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("paintImmediately"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).paintImmediately(rectangle);
            }
        });
    }

    public void putClientProperty(final Object object, final Object object1) {
        this.runMapping(new Operator.MapVoidAction("putClientProperty"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).putClientProperty(object, object1);
            }
        });
    }

    public void registerKeyboardAction(final ActionListener actionListener, final String string, final KeyStroke keyStroke, final int i) {
        this.runMapping(new Operator.MapVoidAction("registerKeyboardAction"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).registerKeyboardAction(actionListener, string, keyStroke, i);
            }
        });
    }

    public void registerKeyboardAction(final ActionListener actionListener, final KeyStroke keyStroke, final int i) {
        this.runMapping(new Operator.MapVoidAction("registerKeyboardAction"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).registerKeyboardAction(actionListener, keyStroke, i);
            }
        });
    }

    public void removeAncestorListener(final AncestorListener ancestorListener) {
        this.runMapping(new Operator.MapVoidAction("removeAncestorListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).removeAncestorListener(ancestorListener);
            }
        });
    }

    public void removeVetoableChangeListener(final VetoableChangeListener vetoableChangeListener) {
        this.runMapping(new Operator.MapVoidAction("removeVetoableChangeListener"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).removeVetoableChangeListener(vetoableChangeListener);
            }
        });
    }

    public void repaint(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("repaint"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).repaint(rectangle);
            }
        });
    }

    public boolean requestDefaultFocus() {
        return this.runMapping(new Operator.MapBooleanAction("requestDefaultFocus"){

            public boolean map() {
                return ((JComponent)JComponentOperator.this.getSource()).requestDefaultFocus();
            }
        });
    }

    public void resetKeyboardActions() {
        this.runMapping(new Operator.MapVoidAction("resetKeyboardActions"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).resetKeyboardActions();
            }
        });
    }

    public void revalidate() {
        this.runMapping(new Operator.MapVoidAction("revalidate"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).revalidate();
            }
        });
    }

    public void scrollRectToVisible(final Rectangle rectangle) {
        this.runMapping(new Operator.MapVoidAction("scrollRectToVisible"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).scrollRectToVisible(rectangle);
            }
        });
    }

    public void setAlignmentX(final float f) {
        this.runMapping(new Operator.MapVoidAction("setAlignmentX"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setAlignmentX(f);
            }
        });
    }

    public void setAlignmentY(final float f) {
        this.runMapping(new Operator.MapVoidAction("setAlignmentY"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setAlignmentY(f);
            }
        });
    }

    public void setAutoscrolls(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setAutoscrolls"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setAutoscrolls(b);
            }
        });
    }

    public void setBorder(final Border border) {
        this.runMapping(new Operator.MapVoidAction("setBorder"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setBorder(border);
            }
        });
    }

    public void setDebugGraphicsOptions(final int i) {
        this.runMapping(new Operator.MapVoidAction("setDebugGraphicsOptions"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setDebugGraphicsOptions(i);
            }
        });
    }

    public void setDoubleBuffered(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setDoubleBuffered"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setDoubleBuffered(b);
            }
        });
    }

    public void setMaximumSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setMaximumSize"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setMaximumSize(dimension);
            }
        });
    }

    public void setMinimumSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setMinimumSize"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setMinimumSize(dimension);
            }
        });
    }

    public void setNextFocusableComponent(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setNextFocusableComponent"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setNextFocusableComponent(component);
            }
        });
    }

    public void setOpaque(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setOpaque"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setOpaque(b);
            }
        });
    }

    public void setPreferredSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setPreferredSize"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setPreferredSize(dimension);
            }
        });
    }

    public void setRequestFocusEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setRequestFocusEnabled"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setRequestFocusEnabled(b);
            }
        });
    }

    public void setToolTipText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setToolTipText"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).setToolTipText(string);
            }
        });
    }

    public void unregisterKeyboardAction(final KeyStroke keyStroke) {
        this.runMapping(new Operator.MapVoidAction("unregisterKeyboardAction"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).unregisterKeyboardAction(keyStroke);
            }
        });
    }

    public void updateUI() {
        this.runMapping(new Operator.MapVoidAction("updateUI"){

            public void map() {
                ((JComponent)JComponentOperator.this.getSource()).updateUI();
            }
        });
    }

    static {
        Timeouts.initDefault("JComponentOperator.WaitToolTipTimeout", 10000L);
        Timeouts.initDefault("JComponentOperator.ShowToolTipTimeout", 0L);
    }

    class JToolTipFinder
    extends Operator.Finder {
        public JToolTipFinder(ComponentChooser sf) {
            super(class$javax$swing$JToolTip == null ? (class$javax$swing$JToolTip = JComponentOperator.class$("javax.swing.JToolTip")) : class$javax$swing$JToolTip, sf);
        }

        public JToolTipFinder() {
            super(class$javax$swing$JToolTip == null ? (class$javax$swing$JToolTip = JComponentOperator.class$("javax.swing.JToolTip")) : class$javax$swing$JToolTip);
        }
    }

    class JToolTipWindowFinder
    implements ComponentChooser {
        ComponentChooser ppFinder;

        public JToolTipWindowFinder() {
            this.ppFinder = new ComponentChooser(){

                public boolean checkComponent(Component comp) {
                    return comp.isShowing() && comp.isVisible() && comp instanceof JToolTip;
                }

                public String getDescription() {
                    return "A tool tip";
                }
            };
        }

        public boolean checkComponent(Component comp) {
            if (comp.isShowing() && comp instanceof Window) {
                ComponentSearcher cs = new ComponentSearcher((Container)comp);
                cs.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                return cs.findComponent(this.ppFinder) != null;
            }
            return false;
        }

        public String getDescription() {
            return "A tool tip window";
        }
    }

    public static class JComponentFinder
    extends Operator.Finder {
        public JComponentFinder(ComponentChooser sf) {
            super(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JComponentOperator.class$("javax.swing.JComponent")) : class$javax$swing$JComponent, sf);
        }

        public JComponentFinder() {
            super(class$javax$swing$JComponent == null ? (class$javax$swing$JComponent = JComponentOperator.class$("javax.swing.JComponent")) : class$javax$swing$JComponent);
        }
    }

    public static class JComponentByTipFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;
        boolean compareExactly;
        boolean compareCaseSensitive;

        public JComponentByTipFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public JComponentByTipFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof JComponent && ((JComponent)comp).getToolTipText() != null) {
                return this.comparator.equals(((JComponent)comp).getToolTipText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JComponent with tool tip \"" + this.label + "\"";
        }
    }
}

