/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.combobox;

import java.awt.Component;
import javax.swing.ComboBoxModel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.robotframework.org.laughingpanda.jretrofit.AllMethodsNotImplementedException;
import org.robotframework.org.laughingpanda.jretrofit.Retrofit;
import org.robotframework.org.netbeans.jemmy.operators.JComboBoxOperator;
import org.robotframework.swing.chooser.WithText;
import org.robotframework.swing.common.SmoothInvoker;

public class ItemTextExtractor {
    private final JComboBoxOperator comboboxOperator;

    public ItemTextExtractor(JComboBoxOperator comboboxOperator) {
        this.comboboxOperator = comboboxOperator;
    }

    public int itemCount() {
        return this.comboboxModel().getSize();
    }

    public String getTextFromRenderedComponent(int itemIndex) {
        WithText textElement = this.getComponentWithText(itemIndex);
        return textElement.getText();
    }

    private ComboBoxModel comboboxModel() {
        return this.comboboxOperator.getModel();
    }

    private WithText getComponentWithText(int itemIndex) {
        try {
            return this.coerceToWithText(this.getRenderedComponent(itemIndex));
        }
        catch (AllMethodsNotImplementedException e) {
            return this.wrapElementToWithText(itemIndex);
        }
    }

    private Component getRenderedComponent(final int itemIndex) {
        final JList popupList = this.comboboxOperator.waitList();
        final Object element = this.comboboxModel().getElementAt(itemIndex);
        final boolean isSelected = this.comboboxOperator.getSelectedIndex() == itemIndex;
        final boolean hasFocus = this.comboboxOperator.hasFocus();
        final ListCellRenderer cellRenderer = this.comboboxOperator.getRenderer();
        return (Component)new SmoothInvoker<Component>(){

            @Override
            public Object work() {
                return cellRenderer.getListCellRendererComponent(popupList, element, itemIndex, isSelected, hasFocus);
            }
        }.invoke();
    }

    private WithText coerceToWithText(Object element) {
        return (WithText)Retrofit.complete(element, WithText.class);
    }

    private WithText wrapElementToWithText(final int itemIndex) {
        return new WithText(){

            public String getText() {
                return ItemTextExtractor.this.comboboxModel().getElementAt(itemIndex).toString();
            }
        };
    }
}

