/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.common;

public class Identifier {
    public static final String REGEXP_IDENTIFIER_PREFIX = "regexp=";
    private String identifier;
    private boolean isRegExp;
    private boolean isIndex;

    public Identifier(String identifier) {
        this.identifier = identifier;
        this.isRegExp = this.isRegExpPrefixed(identifier);
        if (this.isRegExp) {
            this.identifier = this.removeRegExpPrefix(this.identifier);
        } else {
            this.isIndex = this.isIndex(this.identifier);
        }
    }

    private boolean isRegExpPrefixed(String id) {
        return id.startsWith(REGEXP_IDENTIFIER_PREFIX);
    }

    private String removeRegExpPrefix(String id) {
        return id.replaceFirst(REGEXP_IDENTIFIER_PREFIX, "");
    }

    public boolean isRegExp() {
        return this.isRegExp;
    }

    public String asString() {
        return this.identifier;
    }

    public boolean isIndex() {
        return this.isIndex;
    }

    public int asIndex() {
        return Integer.parseInt(this.identifier);
    }

    private boolean isIndex(String id) {
        try {
            Integer.parseInt(id);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return this.identifier;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identifier == null ? 0 : this.identifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Identifier other = (Identifier)obj;
        return !(this.identifier == null ? other.identifier != null : !this.identifier.equals(other.identifier));
    }
}

