/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.component;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.component.ComponentOperator;
import org.robotframework.swing.component.ComponentOperatorFactory;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class ComponentKeywords {
    private final IdentifierParsingOperatorFactory<ComponentOperator> operatorFactory = new ComponentOperatorFactory();
    private final IComponentConditionResolver componentExistenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Fails if component exists within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Component Should Not Exist | _myPanel_ |\n")
    @ArgumentNames(value={"identifier"})
    public void componentShouldNotExist(String identifier) {
        Assert.assertFalse("Component '" + identifier + "' exists", this.componentExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if component does not exist within current context.\nYou might want to set the waiting timeout with the keyword `Set Jemmy Timeout`\n\nExample:\n| Component Should Not Exist | _myPanel_ |\n")
    @ArgumentNames(value={"identifier"})
    public void componentShouldExist(String identifier) {
        Assert.assertTrue("Component '" + identifier + "' does not exist", this.componentExistenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Clicks on a component.\nThe number of clicks can be given as second argument.\n\nExample:\n| Click On Component | _myComponent_ |   | |\n| Click On Component | _myComponent_ | 2 | # double click |\n")
    @ArgumentNames(value={"identifier", "times=1"})
    public void clickOnComponent(String identifier, String[] times) {
        this.operator(identifier).clickMouse(this.getTimes(times));
    }

    @RobotKeyword(value="Right clicks on a component.\nExample:\n| Right Click On Component | _myComponent_ |   | |")
    @ArgumentNames(value={"identifier"})
    public void rightClickOnComponent(String identifier) {
        this.operator(identifier).clickMouse(1, 4);
    }

    @RobotKeyword(value="Returns the component's tooltip text.\n\nExample:\n| ${tooltip}= | Get Tooltip Text | _saveButton_ |\n| Should Be Equal    | _Save_ | _${tooltip}_ |\n")
    @ArgumentNames(value={"identifier"})
    public String getTooltipText(String identifier) {
        return this.operator(identifier).getToolTipText();
    }

    @RobotKeyword(value="Sets focus to the component.\nUseful for example when sending keyboard events to a component.\n\nExample:\n| Set Focus To Component | _myTextField_ |           | |\n| Send Keyboard Event    | VK_C          | CTRL_MASK | # paste from clipboard |\n")
    @ArgumentNames(value={"identifier"})
    public void focusToComponent(String identifier) {
        this.operator(identifier).getFocus();
    }

    @RobotKeyword(value="Selects an item from the components context popup menu.\nDoes a right click on the component and selects the specified menu item from the popup menu.\n\nExample:\n| Select From Popup Menu | _myComponent_ | _Actions|Do something_ |\n")
    @ArgumentNames(value={"identifier", "menuPath"})
    public void selectFromPopupMenu(String identifier, String menuPath) {
        JPopupMenuOperator popup = this.operator(identifier).invokePopup();
        popup.pushMenuNoBlock(menuPath, (Operator.StringComparator)new EqualsStringComparator());
    }

    private ComponentOperator operator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    private int getTimes(String[] times) {
        return times.length == 1 ? Integer.parseInt(times[0]) : 1;
    }
}

