/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.context;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.lang.reflect.Method;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.swing.context.ContainerOperator;
import org.robotframework.swing.context.ContainerOperatorFactory;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.factory.OperatorFactory;

@RobotKeywords
public class ContextKeywords {
    private OperatorFactory<ContainerOperator> operatorFactory = new ContainerOperatorFactory();

    @RobotKeyword(value="Selects a container as current context.\nRequires that a parent context has been selected beforehand using `Select Window` or `Select Dialog`.\n\nExample:\n| Select Window  | _Main Window_ | # Selects the 'parent context' |\n| Select Context | _myPanel_     | # Sets _'myPanel'_ as current context |\n")
    @ArgumentNames(value={"identifier"})
    public void selectContext(String identifier) {
        Context.setContext(this.operatorFactory.createOperator(identifier));
    }

    @RobotKeyword(value="Returns the component name in current context or title if window or dialog is selected.\n\nExample:\n| ${context}= | Get Current Context | # Sets the identifier of the current context to a variable |\n")
    public String getCurrentContext() {
        Component component = Context.getContext().getSource();
        if (this.hasTitle(component)) {
            return this.titleOf(component);
        }
        return component.getName();
    }

    private boolean hasTitle(Component component) {
        return component instanceof Frame || component instanceof Dialog;
    }

    private String titleOf(Component component) {
        try {
            Method m = component.getClass().getMethod("getTitle", new Class[0]);
            return (String)m.invoke((Object)component, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

