/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.filechooser;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.netbeans.jemmy.operators.JFileChooserOperator;
import org.robotframework.swing.filechooser.FileChooserOperatorFactory;

@RobotKeywords
public class FileChooserKeywords {
    private FileChooserOperatorFactory fileChooserOperatorFactory = new FileChooserOperatorFactory();

    @RobotKeyword(value="Chooses from a filechooser by pushing the approve button.\nAn optional file name can be provided, which is inserted to the file name textfield.\nExpects the file chooser to be open.\n\nExample:\n| Push Button | _Open File_    |\n| Choose From File Chooser | _/tmp/elements.xml_ |\n")
    @ArgumentNames(value={"*fileName"})
    public void chooseFromFileChooser(String[] fileName) {
        if (fileName.length > 0) {
            this.fileChooserOperator().chooseFile(fileName[0]);
        } else {
            this.fileChooserOperator().approve();
        }
    }

    @RobotKeyword(value="Cancels and closes file chooser.\nExpects the file chooser to be open.\n\nExample:\n| Push Button         | _Open File_ |\n| Cancel File Chooser |             |\n")
    public void cancelFileChooser() {
        this.fileChooserOperator().cancelSelection();
    }

    private JFileChooserOperator fileChooserOperator() {
        return this.fileChooserOperatorFactory.createFileChooserOperator();
    }
}

