/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.slider;

import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.factory.IdentifierParsingOperatorFactory;
import org.robotframework.swing.slider.SliderOperator;
import org.robotframework.swing.slider.SliderOperatorFactory;
import org.robotframework.swing.util.ComponentExistenceResolver;
import org.robotframework.swing.util.IComponentConditionResolver;

@RobotKeywords
public class SliderKeywords {
    private IdentifierParsingOperatorFactory<SliderOperator> operatorFactory = new SliderOperatorFactory();
    private IComponentConditionResolver existenceResolver = new ComponentExistenceResolver(this.operatorFactory);

    @RobotKeyword(value="Fails if slider does not exist within current context.\n\nExample:\n| Slider Should Exist | _mySlider_ |\n")
    @ArgumentNames(value={"identifier"})
    public void sliderShouldExist(String identifier) {
        Assert.assertTrue("Slider '" + identifier + "' doesn't exist.", this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Fails if slider exists within current context.\n\nExample:\n| Slider Should Not Exist | _mySlider_ |\n")
    @ArgumentNames(value={"identifier"})
    public void sliderShouldNotExist(String identifier) {
        Assert.assertFalse("Slider '" + identifier + "' exists.", this.existenceResolver.satisfiesCondition(identifier));
    }

    @RobotKeyword(value="Uses current context to search for a slider and when found, returns its current value.\n\nExample:\n| ${sliderValue}=  | Get Slider Value | _mySlider_    |\n| Should Be Equal As Integers | _12_     | _${sliderValue}_ |\n")
    @ArgumentNames(value={"identifier"})
    public Object getSliderValue(String identifier) {
        return this.sliderOperator(identifier).getValue();
    }

    private SliderOperator sliderOperator(String identifier) {
        return this.operatorFactory.createOperator(identifier);
    }

    @RobotKeyword(value="Sets the value for the slider found from the current context.\n\nExample:\n| Set Slider Value | _mySlider_  | _7_  |\n")
    @ArgumentNames(value={"identifier", "value"})
    public void setSliderValue(String identifier, String value) {
        this.sliderOperator(identifier).setValue(Integer.parseInt(value));
    }
}

