/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tree;

import java.awt.Component;
import javax.swing.JMenuItem;
import org.robotframework.abbot.tester.ComponentTester;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.org.netbeans.jemmy.EventTool;
import org.robotframework.org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.tree.ITreePopupMenuItemFinder;
import org.robotframework.swing.tree.TreePopupMenuItemFinder;
import org.robotframework.swing.tree.TreeSupport;

@RobotKeywords
public class TreeNodePopupKeywords
extends TreeSupport {
    @RobotKeyword(value="Selects an item from the tree node's popup menu.\n\nExample:\n| Select From Tree Node Popup Menu | _myTree_ | _Root|Folder_ | _New Folder_ | ")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "menuPath"})
    public void selectFromTreeNodePopupMenu(String identifier, String nodeIdentifier, String menuPath) {
        JPopupMenuOperator popupOperator = this.treeOperator(identifier).createPopupOperator(nodeIdentifier);
        popupOperator.pushMenu(menuPath, (Operator.StringComparator)new EqualsStringComparator());
    }

    @RobotKeyword(value="Selects an item from the tree node's popup menu and does not wait for a result.\nNeeded if the action starts a process that stays running (e.g. opens a dialog) and the above keyword doesn't return.\nSeparator for items is '|'.\n\nExample:\n| Select From Tree Node Popup Menu In Separate Thread | _myTree_ | _Root|Folder_ | _New Folder_ | ")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "menuPath"})
    public void selectFromTreeNodePopupMenuInSeparateThread(String identifier, String nodeIdentifier, String menuPath) {
        JPopupMenuOperator popupOperator = this.treeOperator(identifier).createPopupOperator(nodeIdentifier);
        popupOperator.pushMenuNoBlock(menuPath, (Operator.StringComparator)new EqualsStringComparator());
    }

    @RobotKeyword(value="Invokes a menu action on all the selected tree nodes.\nDoes not wait for a result.\nSeparator for items is '|'.\n\nExamples:\n| Select Tree Node | _myTree_ | _Root|Folder1_ |\n| Select Tree Node | _myTree_ | _Root|Folder2_ |\n| Select From Popup Menu On Selected Tree Nodes | _myTree_ | _Remove_ | ")
    @ArgumentNames(value={"identifier", "menuPath"})
    public void selectFromPopupMenuOnSelectedTreeNodes(String identifier, String menuPath) {
        JPopupMenuOperator popupOperator = this.treeOperator(identifier).createPopupOperatorOnSelectedNodes();
        popupOperator.pushMenuNoBlock(menuPath, (Operator.StringComparator)new EqualsStringComparator());
        this.waitToAvoidInstability();
    }

    @RobotKeyword(value="Fails if given popup menu item is disabled.\n\nExamples:\n| Tree Node Popup Menu Item Should Be Enabled | _myTree_ | _Root|Folder_ | _New Folder_ |\n| Tree Node Popup Menu Item Should Be Enabled | _0_ | _1_ | _New Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "menuPath"})
    public void treeNodePopupMenuItemShouldBeEnabled(String identifier, String nodeIdentifier, String menuPath) {
        boolean menuItemIsEnabled = this.menuItemIsEnabled(identifier, nodeIdentifier, menuPath);
        Assert.assertTrue("Menu item '" + menuPath + "' was disabled", menuItemIsEnabled);
    }

    @RobotKeyword(value="Fails if given popup menu item is enabled.\n\nExamples:\n| Tree Node Popup Menu Item Should Be Disabled | _myTree_ | _Root|Folder_ | _New Folder_ |\n| Tree Node Popup Menu Item Should Be Disabled | _0_      | _1_ | _New Folder_ |\n")
    @ArgumentNames(value={"identifier", "nodeIdentifier", "menuPath"})
    public void treeNodePopupMenuItemShouldBeDisabled(String identifier, String nodeIdentifier, String menuPath) {
        boolean menuItemIsEnabled = this.menuItemIsEnabled(identifier, nodeIdentifier, menuPath);
        Assert.assertFalse("Menu item '" + menuPath + "' was enabled", menuItemIsEnabled);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean menuItemIsEnabled(String identifier, String nodeIdentifier, String menuPath) {
        try {
            boolean bl = this.createPopupMenuItem(identifier, nodeIdentifier, menuPath).isEnabled();
            return bl;
        }
        finally {
            this.closePopup();
        }
    }

    private void closePopup() {
        new ComponentTester().actionKeyStroke(27);
    }

    private JMenuItem createPopupMenuItem(String identifier, String nodeIdentifier, String menuPath) {
        Component source = this.treeOperator(identifier).getSource();
        return this.createPopupMenuItemFinder(source).findMenu(nodeIdentifier, menuPath);
    }

    ITreePopupMenuItemFinder createPopupMenuItemFinder(Component source) {
        return new TreePopupMenuItemFinder(source);
    }

    void waitToAvoidInstability() {
        new EventTool().waitNoEvent(300L);
    }
}

