/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.popup;

import java.awt.Point;
import javax.swing.JPopupMenu;
import org.robotframework.org.netbeans.jemmy.EventTool;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.swing.popup.PopupCaller;

public class PopupMenuOperatorFactory {
    private EventTool eventTool = new EventTool();
    private PopupCaller popupCaller = new PopupCaller();

    public JPopupMenuOperator createPopupOperator(ComponentOperator componentOperator) {
        Point pointToClick = this.getPointToClick(componentOperator);
        JPopupMenu popupMenu = this.callPopupOnComponent(componentOperator, pointToClick);
        return this.createPopupOperator(popupMenu);
    }

    public JPopupMenuOperator createPopupOperator(JPopupMenu popupMenu) {
        JPopupMenuOperator popupMenuOperator = this.wrapWithOperator(popupMenu);
        popupMenuOperator.grabFocus();
        this.waitToAvoidInstability();
        return popupMenuOperator;
    }

    public JPopupMenu callPopupOnComponent(ComponentOperator componentOperator, Point pointToClick) {
        return this.popupCaller.callPopupOnComponent(componentOperator, pointToClick);
    }

    protected void waitToAvoidInstability() {
        this.eventTool.waitNoEvent(500L);
    }

    JPopupMenuOperator wrapWithOperator(JPopupMenu popupMenu) {
        return new JPopupMenuOperator(popupMenu);
    }

    private Point getPointToClick(ComponentOperator componentOperator) {
        int x = componentOperator.getCenterX();
        int y = componentOperator.getCenterY();
        return new Point(x, y);
    }
}

