/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

class ContentChangingCombobox
extends JComboBox
implements ActionListener {
    private static final String REMOVABLE_ITEM = "Removable";
    private static final String[] ITEMS = new String[]{"Foo", "Bar", "Quux", "Removable"};

    public ContentChangingCombobox() {
        this.setEditable(true);
        this.setName("contentChangingCombobox");
        this.addActionListener(this);
        this.setModel(new DefaultComboBoxModel<String>(ITEMS));
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getActionCommand().equals("comboBoxChanged")) {
            String selected = (String)this.getSelectedItem();
            ArrayList<String> items = new ArrayList<String>();
            if (!selected.equals(REMOVABLE_ITEM)) {
                items.add(selected);
            }
            ComboBoxModel model = this.getModel();
            int size = model.getSize();
            for (int i = 0; i < size; ++i) {
                String item = (String)model.getElementAt(i);
                if (item == selected) continue;
                items.add(item);
            }
            this.setModel(new DefaultComboBoxModel<Object>(items.toArray()));
            this.setSelectedIndex(0);
        }
    }

    public void resetModel() {
        this.setModel(new DefaultComboBoxModel<String>(ITEMS));
    }
}

