/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.robotframework.javalib.util.ArrayUtil;
import org.robotframework.org.netbeans.jemmy.Waitable;
import org.robotframework.org.netbeans.jemmy.operators.JTreeOperator;
import org.robotframework.swing.tree.NodeTextExtractor;
import org.robotframework.swing.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreePathWaitable
implements Waitable {
    private final String path;
    private final JTreeOperator treeOperator;

    public TreePathWaitable(JTreeOperator treeOperator, String path) {
        this.treeOperator = treeOperator;
        this.path = path;
    }

    @Override
    public Object actionProduced(Object ignoredHere) {
        return this.buildTreePath(this.parse(this.path));
    }

    @Override
    public String getDescription() {
        return "Building tree path for: " + this.path;
    }

    private String[] parse(String path) {
        return this.removeRootIfNecessary(path.split("\\|"));
    }

    private String[] removeRootIfNecessary(String[] nodeNames) {
        if (this.rootIsVisibleAndEqualsToRootIn(nodeNames)) {
            return this.removeRoot(nodeNames);
        }
        return nodeNames;
    }

    private boolean rootIsVisibleAndEqualsToRootIn(String[] nodeNames) {
        String rootText = this.getNodeText(this.getRoot());
        return this.rootIsVisible() && nodeNames.length > 0 && nodeNames[0].equals(rootText);
    }

    private String[] removeRoot(String[] nodeNames) {
        return ArrayUtil.copyOfRange(nodeNames, 1, nodeNames.length);
    }

    private TreePath buildTreePath(String[] nodeNames) {
        Object root = this.getRoot();
        TreePath treePathToNode = new TreePath(root);
        Iterator<Object> currentLevelChildren = this.getChildren(root);
        for (String nodeName : nodeNames) {
            boolean foundMatch = false;
            while (currentLevelChildren.hasNext()) {
                Object currentNode = currentLevelChildren.next();
                if (!this.nodeTextEquals(nodeName, currentNode)) continue;
                currentLevelChildren = this.getChildren(currentNode);
                treePathToNode = treePathToNode.pathByAddingChild(currentNode);
                foundMatch = true;
                break;
            }
            if (foundMatch) continue;
            return null;
        }
        return treePathToNode;
    }

    private boolean nodeTextEquals(String nodeName, Object node) {
        String nodeText = this.getNodeText(node);
        return ObjectUtils.nullSafeEquals(nodeText, nodeName);
    }

    private String getNodeText(Object node) {
        JTree tree = (JTree)this.treeOperator.getSource();
        return new NodeTextExtractor(tree).getText(node, this.path);
    }

    private Object getRoot() {
        return this.treeOperator.getModel().getRoot();
    }

    private boolean rootIsVisible() {
        return this.treeOperator.isRootVisible();
    }

    private Iterator<Object> getChildren(Object node) {
        TreeModel model = this.treeOperator.getModel();
        int childCount = model.getChildCount(node);
        ArrayList<Object> children = new ArrayList<Object>(childCount);
        for (int i = 0; i < childCount; ++i) {
            children.add(model.getChild(node, i));
        }
        return children.iterator();
    }
}

