/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.util;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyExtractor {
    public Map<String, Object> extractProperties(Object bean) {
        try {
            return this.parsePropertyValuesFrom(bean);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, Object> parsePropertyValuesFrom(Object bean) throws Exception {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        for (Method method : bean.getClass().getMethods()) {
            if (!this.isGetter(method)) continue;
            Object value = this.invoke(bean, method);
            String prop = this.parsePropNameFrom(method);
            properties.put(prop, value);
        }
        return properties;
    }

    private boolean isGetter(Method m) {
        String methodName = m.getName();
        return methodName.startsWith("get") && m.getParameterTypes().length == 0 && !methodName.equals("getClass");
    }

    private Object invoke(Object bean, Method method) {
        try {
            return method.invoke(bean, new Object[0]);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    private String parsePropNameFrom(Method method) {
        return Character.toLowerCase(method.getName().charAt(3)) + method.getName().substring(4);
    }
}

