/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.abbot.util;

import java.awt.EventQueue;
import java.util.Properties;
import javax.swing.SwingUtilities;
import org.robotframework.abbot.Log;
import org.robotframework.abbot.util.AWT;

public class EventDispatchExceptionHandler {
    public static final String PROP_NAME = "sun.awt.exception.handler";
    private static boolean installed = false;
    private static boolean canInstall = true;
    static /* synthetic */ Class class$java$lang$Throwable;

    public void install() {
        if (SwingUtilities.isEventDispatchThread()) {
            throw new IllegalStateException("Handler must not be installed from the event dispatch thread");
        }
        Class<?> cls = this.getClass();
        final String className = cls.getName();
        try {
            cls.newInstance();
        }
        catch (Exception e) {
            String msg = "Exception handler (" + cls + ") must have an accessible no-args Constructor: " + e;
            throw new IllegalArgumentException(msg);
        }
        if (installed) {
            Log.debug("Exception handler class already installed");
            System.setProperty(PROP_NAME, className);
        } else if (!canInstall) {
            Log.warn("Can't install event dispatch exception handler");
        } else {
            Log.log("Attempting to install handler " + className);
            class PropertiesHolder {
                public Properties properties = null;

                PropertiesHolder() {
                }
            }
            final PropertiesHolder holder = new PropertiesHolder();
            EventQueue.invokeLater(new Runnable(){
                {
                }

                public void run() {
                    holder.properties = (Properties)System.getProperties().clone();
                    System.setProperty(EventDispatchExceptionHandler.PROP_NAME, className);
                    throw new DummyException();
                }
            });
            AWT.invokeAndWait(new Runnable(){

                public void run() {
                }
            });
            System.setProperties(holder.properties);
            String oldHandler = System.getProperty(PROP_NAME);
            if (installed) {
                if (oldHandler != null) {
                    Log.debug("Replaced an existing event exception handler (" + oldHandler + ")");
                }
            } else {
                canInstall = false;
                String msg = "The handler for event dispatch thread exceptions could not be installed";
                if (oldHandler != null) {
                    msg = msg + " (" + oldHandler + " has already been " + "set and cached; there is no way to override it)";
                }
                Log.warn(msg);
                throw new RuntimeException(msg);
            }
        }
    }

    protected void exceptionCaught(Throwable thrown) {
        System.err.println("Exception caught on event dispatch thread: " + thrown);
    }

    public void handle(Throwable thrown) {
        Log.debug("Handling event dispatch exception: " + thrown);
        String handler = System.getProperty(PROP_NAME);
        boolean handled = false;
        if (handler != null && !handler.equals(this.getClass().getName())) {
            Log.debug("A user exception handler (" + handler + ") has been set, invoking it");
            try {
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Class<?> c = Class.forName(handler, true, cl);
                c.getMethod("handle", class$java$lang$Throwable == null ? (class$java$lang$Throwable = EventDispatchExceptionHandler.class$("java.lang.Throwable")) : class$java$lang$Throwable).invoke(c.newInstance(), thrown);
                handled = true;
            }
            catch (Throwable e) {
                Log.warn("Could not invoke user handler: " + e);
            }
        }
        if (thrown instanceof DummyException) {
            Log.debug("Installation succeeded");
            installed = true;
        } else if (!handled) {
            Log.debug("Handling exception on event dispatch thread: " + thrown + " with " + this.getClass());
            Log.debug(thrown);
            this.exceptionCaught(thrown);
        }
        Log.debug("Handling done");
    }

    public static boolean isInstalled() {
        return installed;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class DummyException
    extends RuntimeException {
        private DummyException() {
        }

        public String toString() {
            return super.toString() + " " + this.getClass().getClassLoader();
        }
    }
}

