/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy;

import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.TimeoutExpiredException;

public class Timeout {
    private String name;
    private long value;
    private long startTime;

    public Timeout(String name, long value) {
        this.name = name;
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public long getValue() {
        return this.value;
    }

    public void sleep() {
        if (this.getValue() > 0L) {
            try {
                Thread.currentThread();
                Thread.sleep(this.getValue());
            }
            catch (InterruptedException e) {
                throw new JemmyException("Sleep " + this.getName() + " was interrupted!", e);
            }
        }
    }

    public void start() {
        this.startTime = System.currentTimeMillis();
    }

    public boolean expired() {
        return System.currentTimeMillis() - this.startTime > this.getValue();
    }

    public void check() {
        if (this.expired()) {
            throw new TimeoutExpiredException(this.getName() + " timeout expired!");
        }
    }
}

