/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import javax.swing.JButton;
import org.robotframework.org.netbeans.jemmy.ComponentSearcher;
import org.robotframework.org.netbeans.jemmy.drivers.ButtonDriver;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.LightSupportiveDriver;
import org.robotframework.org.netbeans.jemmy.drivers.ScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JButtonOperator;
import org.robotframework.org.netbeans.jemmy.operators.JSplitPaneOperator;

public class JSplitPaneDriver
extends LightSupportiveDriver
implements ScrollDriver {
    public JSplitPaneDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.JSplitPaneOperator"});
    }

    public void scroll(ComponentOperator oper, ScrollAdjuster adj) {
        this.moveDividerTo((JSplitPaneOperator)oper, adj);
    }

    public void scrollToMinimum(ComponentOperator oper, int orientation) {
        this.expandTo((JSplitPaneOperator)oper, 0);
    }

    public void scrollToMaximum(ComponentOperator oper, int orientation) {
        this.expandTo((JSplitPaneOperator)oper, 1);
    }

    private void moveDividerTo(JSplitPaneOperator oper, ScrollAdjuster adj) {
        ContainerOperator divOper = oper.getDivider();
        if (oper.getDividerLocation() == -1) {
            this.moveTo(oper, divOper, divOper.getCenterX() - 1, divOper.getCenterY() - 1);
            if (oper.getDividerLocation() == -1) {
                this.moveTo(oper, divOper, divOper.getCenterX() + 1, divOper.getCenterY() + 1);
            }
        }
        if (oper.getOrientation() == 1) {
            this.moveOnce(oper, divOper, adj, 0, oper.getWidth());
        } else {
            this.moveOnce(oper, divOper, adj, 0, oper.getHeight());
        }
    }

    private void moveOnce(JSplitPaneOperator oper, ContainerOperator divOper, ScrollAdjuster adj, int leftPosition, int rightPosition) {
        int currentLocation = oper.getDividerLocation();
        int currentPosition = 0;
        currentPosition = oper.getOrientation() == 1 ? (int)(divOper.getLocationOnScreen().getX() - oper.getLocationOnScreen().getX()) : (int)(divOper.getLocationOnScreen().getY() - oper.getLocationOnScreen().getY());
        int nextPosition = 0;
        if (adj.getScrollDirection() == -1) {
            nextPosition = (currentPosition + leftPosition) / 2;
            this.moveToPosition(oper, divOper, nextPosition - currentPosition);
            if (currentPosition == (int)(divOper.getLocationOnScreen().getY() - oper.getLocationOnScreen().getY())) {
                return;
            }
            this.moveOnce(oper, divOper, adj, leftPosition, currentPosition);
        } else if (adj.getScrollDirection() == 1) {
            nextPosition = (currentPosition + rightPosition) / 2;
            this.moveToPosition(oper, divOper, nextPosition - currentPosition);
            if (currentPosition == (int)(divOper.getLocationOnScreen().getY() - oper.getLocationOnScreen().getY())) {
                return;
            }
            this.moveOnce(oper, divOper, adj, currentPosition, rightPosition);
        } else {
            return;
        }
    }

    private void moveTo(JSplitPaneOperator oper, ComponentOperator divOper, int x, int y) {
        DriverManager.getMouseDriver(divOper).dragNDrop(divOper, divOper.getCenterX(), divOper.getCenterY(), x, y, oper.getDefaultMouseButton(), 0, oper.getTimeouts().create("ComponentOperator.BeforeDragTimeout"), oper.getTimeouts().create("ComponentOperator.AfterDragTimeout"));
    }

    private void moveToPosition(JSplitPaneOperator oper, ComponentOperator divOper, int nextPosition) {
        if (System.getProperty("java.version").startsWith("1.2")) {
            oper.setDividerLocation(nextPosition);
        }
        if (oper.getOrientation() == 1) {
            this.moveTo(oper, divOper, divOper.getCenterX() + nextPosition, divOper.getCenterY());
        } else {
            this.moveTo(oper, divOper, divOper.getCenterX(), divOper.getCenterY() + nextPosition);
        }
    }

    private void expandTo(JSplitPaneOperator oper, int index) {
        ContainerOperator divOper = oper.getDivider();
        JButtonOperator bo = new JButtonOperator((JButton)divOper.waitSubComponent(new JButtonOperator.JButtonFinder(ComponentSearcher.getTrueChooser("JButton")), index));
        bo.copyEnvironment(divOper);
        ButtonDriver bdriver = DriverManager.getButtonDriver(bo);
        bdriver.push(bo);
        bdriver.push(bo);
    }
}

