/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import java.awt.Point;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.AWTScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.ScrollbarOperator;

public class ScrollbarDriver
extends AWTScrollDriver {
    private static final int CLICK_OFFSET = 5;

    public ScrollbarDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.ScrollbarOperator"});
    }

    public void scrollToMinimum(final ComponentOperator oper, int orientation) {
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollDirection() {
                return ((ScrollbarOperator)oper).getMinimum() < ((ScrollbarOperator)oper).getValue() ? -1 : 0;
            }

            public int getScrollOrientation() {
                return ((ScrollbarOperator)oper).getOrientation();
            }

            public String getDescription() {
                return "Scroll to minimum";
            }
        });
    }

    public void scrollToMaximum(final ComponentOperator oper, int orientation) {
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollDirection() {
                return ((ScrollbarOperator)oper).getMaximum() - ((ScrollbarOperator)oper).getVisibleAmount() > ((ScrollbarOperator)oper).getValue() ? 1 : 0;
            }

            public int getScrollOrientation() {
                return ((ScrollbarOperator)oper).getOrientation();
            }

            public String getDescription() {
                return "Scroll to maximum";
            }
        });
    }

    protected Point getClickPoint(ComponentOperator oper, int direction, int orientation) {
        int y;
        int x;
        if (orientation == 0) {
            if (direction == 1) {
                x = oper.getWidth() - 1 - 5;
            } else if (direction == -1) {
                x = 5;
            } else {
                return null;
            }
            y = oper.getHeight() / 2;
        } else if (orientation == 1) {
            if (direction == 1) {
                y = oper.getHeight() - 1 - 5;
            } else if (direction == -1) {
                y = 5;
            } else {
                return null;
            }
            x = oper.getWidth() / 2;
        } else {
            return null;
        }
        return new Point(x, y);
    }
}

