/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.combobox;

import java.awt.Component;
import java.util.ArrayList;
import org.robotframework.org.netbeans.jemmy.EventTool;
import org.robotframework.org.netbeans.jemmy.Waiter;
import org.robotframework.org.netbeans.jemmy.operators.JComboBoxOperator;
import org.robotframework.swing.combobox.ComboboxSelectedItemWaitable;
import org.robotframework.swing.combobox.ItemTextExtractor;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.common.TimeoutCopier;
import org.robotframework.swing.operator.ComponentWrapper;

public class ComboBoxOperator
extends IdentifierSupport
implements ComponentWrapper {
    private final JComboBoxOperator comboboxOperator;
    private final ItemTextExtractor itemTextExtractor;

    public ComboBoxOperator(JComboBoxOperator jComboboxOperator) {
        this.comboboxOperator = jComboboxOperator;
        this.itemTextExtractor = new ItemTextExtractor(jComboboxOperator);
    }

    ComboBoxOperator(JComboBoxOperator jComboboxOperator, ItemTextExtractor itemTextExtractor) {
        this.comboboxOperator = jComboboxOperator;
        this.itemTextExtractor = itemTextExtractor;
    }

    public void disableVerification() {
        this.comboboxOperator.setVerification(false);
    }

    public Component getSource() {
        return this.comboboxOperator.getSource();
    }

    public void selectItem(final String comboItemIdentifier) {
        new ComboboxAction(){

            protected Object executeWhenComboBoxOpen() {
                int itemIndex = ComboBoxOperator.this.findItemIndex(comboItemIdentifier);
                boolean verificationEnabled = ComboBoxOperator.this.comboboxOperator.getVerification();
                ComboBoxOperator.this.comboboxOperator.setVerification(false);
                ComboBoxOperator.this.comboboxOperator.selectItem(itemIndex);
                if (verificationEnabled) {
                    ComboBoxOperator.this.verifyItemSelection(comboItemIdentifier);
                }
                return null;
            }
        }.execute();
    }

    private void verifyItemSelection(String comboItemIdentifier) {
        try {
            Waiter waiter = this.comboboxSelectedItemWaiter(this, comboItemIdentifier);
            Object selectedItem = waiter.waitAction(null);
            if (selectedItem == null) {
                throw new RuntimeException("Expected selection to be '" + comboItemIdentifier + "' but no selection found");
            }
            if (!comboItemIdentifier.equals(selectedItem.toString())) {
                throw new RuntimeException("Expected selection to be '" + comboItemIdentifier + "' but was '" + selectedItem + "'");
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Waiter comboboxSelectedItemWaiter(ComboBoxOperator comboboxOperator, String itemIdentifier) {
        Waiter waiter = new Waiter(new ComboboxSelectedItemWaitable(comboboxOperator, itemIdentifier));
        waiter.setTimeouts(new TimeoutCopier(comboboxOperator.getComboboxOperator(), "JComboboxOperator.WaitGetSelectedItemTimeout").getTimeouts());
        return waiter;
    }

    private int findItemIndex(String comboItemIdentifier) {
        if (this.isIndex(comboItemIdentifier)) {
            return this.asIndex(comboItemIdentifier);
        }
        return this.findItemIndexWithRenderer(comboItemIdentifier);
    }

    private int findItemIndexWithRenderer(String expectedText) {
        int itemCount = this.itemTextExtractor.itemCount();
        for (int itemIndex = 0; itemIndex < itemCount; ++itemIndex) {
            String text = this.itemTextExtractor.getTextFromRenderedComponent(itemIndex);
            if (!expectedText.equals(text)) continue;
            return itemIndex;
        }
        throw new RuntimeException("Couldn't find text '" + expectedText + "'");
    }

    public Object getSelectedItem() {
        return new ComboboxAction(){

            protected Object executeWhenComboBoxOpen() {
                return ComboBoxOperator.this.itemTextExtractor.getTextFromRenderedComponent(ComboBoxOperator.this.comboboxOperator.getSelectedIndex());
            }
        }.execute();
    }

    public Object getSelectedItemFromDisabledComboBox() {
        return this.comboboxOperator.getSelectedItem();
    }

    public boolean isEnabled() {
        return this.comboboxOperator.isEnabled();
    }

    public void typeText(String text) {
        this.comboboxOperator.clearText();
        this.comboboxOperator.typeText(text);
    }

    public String[] getValues() {
        return (String[])new ComboboxAction(){

            protected Object executeWhenComboBoxOpen() {
                ArrayList<String> values = new ArrayList<String>();
                int itemCount = ComboBoxOperator.this.itemTextExtractor.itemCount();
                for (int i = 0; i < itemCount; ++i) {
                    values.add(ComboBoxOperator.this.itemTextExtractor.getTextFromRenderedComponent(i));
                }
                return values.toArray(new String[0]);
            }
        }.execute();
    }

    public JComboBoxOperator getComboboxOperator() {
        return this.comboboxOperator;
    }

    private abstract class ComboboxAction {
        private ComboboxAction() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object execute() {
            try {
                ComboBoxOperator.this.comboboxOperator.pushComboButton();
                Object object = this.executeWhenComboBoxOpen();
                return object;
            }
            finally {
                ComboBoxOperator.this.comboboxOperator.hidePopup();
                this.waitToAvoidInstability();
            }
        }

        private void waitToAvoidInstability() {
            new EventTool().waitNoEvent(200L);
        }

        protected abstract Object executeWhenComboBoxOpen();
    }
}

