/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.concurrent;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.javalib.util.KeywordNameNormalizer;
import org.robotframework.org.apache.commons.collections.CollectionUtils;
import org.robotframework.org.apache.commons.collections.Transformer;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.SwingLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RobotKeywords
public class ThreadKeywords {
    private KeywordNameNormalizer normalizer = new KeywordNameNormalizer();

    @RobotKeyword(value="Executes the given keyword with the given arguments in a separate thread.\nUseful if the given keyword starts a process that stays running (e.g. opens a dialog) and doesn't return.\nKnown limitations:\n- The return value of the keyword being run is ignored.\n- Exceptions thrown by the keyword are ignored, which implies that this keyword should not be used\n  in conjunction with keywords such `Label Text Should Be` or `Menu Item Should Be Enabled`.\n")
    @ArgumentNames(value={"keywordName", "*arguments"})
    public void runKeywordInSeparateThread(final String keywordName, final Object ... arguments) {
        this.assertKeywordExists(keywordName);
        this.assertArgumentCountIsCorrect(keywordName, arguments);
        new Thread(){

            public void run() {
                SwingLibrary.instance.runKeyword(keywordName, arguments);
            }
        }.start();
    }

    public String stringify(String keywordName, Object ... arguments) {
        this.assertKeywordExists(keywordName);
        this.assertArgumentCountIsCorrect(keywordName, arguments);
        return SwingLibrary.instance.runKeyword(keywordName, arguments).toString();
    }

    private void assertArgumentCountIsCorrect(String keywordName, Object[] arguments) {
        String[] keywordArguments = SwingLibrary.instance.getKeywordArguments(this.normalizer.normalize(keywordName));
        if (keywordArguments == null) {
            return;
        }
        String errorMessage = "Expected " + keywordArguments.length + " but got " + arguments.length + " arguments.     ";
        Assert.assertEquals(errorMessage, keywordArguments.length, arguments.length);
    }

    private void assertKeywordExists(String keywordName) {
        Collection<String> normalizedKeywordNames = this.normalizeKeywordNames(SwingLibrary.instance.getKeywordNames());
        String normalizedKeywordName = this.normalizer.normalize(keywordName);
        boolean keywordExists = normalizedKeywordNames.contains(normalizedKeywordName);
        Assert.assertTrue("Keyword '" + keywordName + "' was not found.", keywordExists);
    }

    private Collection<String> normalizeKeywordNames(String[] keywordNames) {
        List<String> keywordsList = Arrays.asList(keywordNames);
        return CollectionUtils.collect(keywordsList, new Transformer(){

            public Object transform(Object input) {
                return ThreadKeywords.this.normalizer.normalize(input.toString());
            }
        });
    }
}

