/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.tab;

import java.awt.Component;
import java.awt.Container;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.netbeans.jemmy.operators.JTabbedPaneOperator;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.tab.TabOperator;
import org.robotframework.swing.tab.TabPaneOperatorFactory;
import org.robotframework.swing.tab.TabbedPaneOperator;

@RobotKeywords
public class TabKeywords
extends IdentifierSupport {
    private TabPaneOperatorFactory paneOperatorFactory = new TabPaneOperatorFactory();

    @RobotKeyword(value="Selects a tab.\nThe optional tab pane identifier can be provided, otherwise the first matching tab is selected.\n\nExample:\n| Select Tab | _Customer Information_ |\n| Select Tab | _Customer Information_ | _Customers_ |\n")
    @ArgumentNames(value={"tabIdentifier", "*tabPaneIdentifier"})
    public void selectTab(String tabIdentifier, String[] tabPaneIdentifier) {
        this.selectTheTab(tabIdentifier, tabPaneIdentifier);
    }

    private Component selectTheTab(String tabIdentifier, String[] tabPaneIdentifier) {
        if (this.notNullOrBlank(tabPaneIdentifier)) {
            this.selectTabPane(tabPaneIdentifier[0]);
        }
        return this.selectTabPage(tabIdentifier);
    }

    private boolean notNullOrBlank(String[] tabPaneIdentifier) {
        return tabPaneIdentifier != null && tabPaneIdentifier.length > 0;
    }

    private Component selectTabPage(String tabIdentifier) {
        return this.createTabPane().selectPage(this.indexOfTab(tabIdentifier));
    }

    private int indexOfTab(String tabIdentifier) {
        if (this.isIndex(tabIdentifier)) {
            return Integer.valueOf(tabIdentifier);
        }
        return this.createTabPane().indexOfTab(tabIdentifier);
    }

    @RobotKeyword(value="Selects a tab and sets it as the context.\nThe optional tab pane identifier can be provided, otherwise the first matching tab is selected.\n\nExample:\n| Select Tab | _Customer Information_ |\n| Select Tab | _Customer Information_ | _Customers_ |\n")
    @ArgumentNames(value={"tabIdentifier", "*tabPaneIdentifier"})
    public void selectTabAsContext(String tabIdentifier, String[] tabPaneIdentifier) {
        try {
            Component container = this.selectTheTab(tabIdentifier, tabPaneIdentifier);
            this.setAsContext((Container)container);
        }
        catch (Exception e) {
            throw new RuntimeException("Can't select tab: " + tabIdentifier + " because it doesn't contain any container.");
        }
    }

    private void setAsContext(Container container) {
        TabOperator operator = new TabOperator(container);
        Context.setContext(operator);
    }

    @RobotKeyword(value="Returns the label of the tab that is currenctly selected.\nExpects that only one tab pane exists in the current context.\nIf you need to operate on a different tab pane use `Select Tab Pane` keyword first.\n\nExample:\n| ${currentTab}= | Get Selected Tab Label |\n| Should Be Equal | _Customer Information_ | ${currentTab} |\n")
    public String getSelectedTabLabel() {
        JTabbedPaneOperator paneOperator = this.createTabPane();
        return paneOperator.getTitleAt(paneOperator.getSelectedIndex());
    }

    @RobotKeyword(value="Sets a tab pane as the current context.\nUseful if you have several tab panes in the window.\n\nExample:\n| Select Tab Pane | _Other Tab Pane_ |\n| Select Tab | _Customer Information_ |\n")
    @ArgumentNames(value={"tabPaneIdentifier"})
    public void selectTabPane(String tabPaneIdentifier) {
        TabbedPaneOperator operator = this.paneOperatorFactory.createOperator(tabPaneIdentifier);
        Context.setContext(operator);
    }

    private JTabbedPaneOperator createTabPane() {
        return this.paneOperatorFactory.createOperatorFromContext();
    }
}

