/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.table;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class OptionalArgsForTableCellClicking {
    private static final Map<String, String> keyAliases = new HashMap<String, String>(){
        {
            this.put("LEFT BUTTON", "BUTTON1_MASK");
            this.put("RIGHT BUTTON", "BUTTON2_MASK");
            this.put("CTRL", "CTRL_MASK");
            this.put("ALT", "ALT_MASK");
            this.put("ALT GR", "ALT_GRAPH_MASK");
            this.put("SHIFT", "SHIFT_MASK");
            this.put("META", "META_MASK");
        }
    };
    private String[] optionalArgs;

    public OptionalArgsForTableCellClicking(String[] optionalArgs) {
        this.optionalArgs = optionalArgs;
    }

    public String clickCount() {
        if (this.clickCountSpecified()) {
            return this.getClickCount();
        }
        return "1";
    }

    private boolean clickCountSpecified() {
        return this.optionalArgs.length > 0;
    }

    private String getClickCount() {
        return this.optionalArgs[0];
    }

    public String button() {
        if (this.buttonSpecified()) {
            return this.getButton();
        }
        return "BUTTON1_MASK";
    }

    private boolean buttonSpecified() {
        return this.optionalArgs.length > 1;
    }

    private String getButton() {
        return this.keyMask(this.optionalArgs[1]);
    }

    private String keyMask(String arg) {
        String upperCasedArg = arg.toUpperCase();
        String keyMask = keyAliases.get(upperCasedArg);
        if (keyMask != null) {
            return keyMask;
        }
        return upperCasedArg;
    }

    public String[] keyModifiers() {
        if (this.keymodifiersSpecifiedIn()) {
            return this.getKeyModifiers();
        }
        return new String[0];
    }

    private boolean keymodifiersSpecifiedIn() {
        return this.optionalArgs.length > 2;
    }

    private String[] getKeyModifiers() {
        return this.replaceAliasesIn(Arrays.copyOfRange(this.optionalArgs, 2, this.optionalArgs.length));
    }

    private String[] replaceAliasesIn(String[] keyModifiers) {
        String[] mods = new String[keyModifiers.length];
        for (int i = 0; i < keyModifiers.length; ++i) {
            mods[i] = this.keyMask(keyModifiers[i]);
        }
        return mods;
    }
}

