/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.table;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.InputEvent;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Map;
import javax.swing.table.TableColumn;
import org.robotframework.org.netbeans.jemmy.operators.JMenuItemOperator;
import org.robotframework.org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.org.netbeans.jemmy.operators.JTableOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.swing.common.IdentifierSupport;
import org.robotframework.swing.comparator.EqualsStringComparator;
import org.robotframework.swing.operator.ComponentWrapper;
import org.robotframework.swing.table.CellValueExtractor;
import org.robotframework.swing.table.ColumnIndexTableCellChooser;
import org.robotframework.swing.table.ColumnNameTableCellChooser;
import org.robotframework.swing.table.InvalidCellException;
import org.robotframework.swing.table.TableHeaderOperator;
import org.robotframework.swing.util.PropertyExtractor;
import org.robotframework.swing.util.SwingInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableOperator
extends IdentifierSupport
implements ComponentWrapper {
    private final JTableOperator jTableOperator;
    private PropertyExtractor propertyExtractor = new PropertyExtractor();
    private CellValueExtractor cellValueExtractor;

    public TableOperator(JTableOperator jTableOperator) {
        this.jTableOperator = jTableOperator;
        this.jTableOperator.setComparator(new EqualsStringComparator());
        this.cellValueExtractor = new CellValueExtractor(jTableOperator);
    }

    public TableHeaderOperator headerOperator() {
        return new TableHeaderOperator(this.jTableOperator.getHeaderOperator());
    }

    public String getCellValue(String row, String columnIdentifier) {
        Point cell = this.findCell(row, columnIdentifier);
        return this.cellValueExtractor.textOf(cell.y, cell.x);
    }

    public boolean isCellEditable(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        return this.jTableOperator.isCellEditable(coordinates.y, coordinates.x);
    }

    public boolean isCellSelected(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        return this.jTableOperator.isCellSelected(coordinates.y, coordinates.x);
    }

    public void selectCell(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.selectCell(coordinates.y, coordinates.x);
    }

    public void addTableCellSelection(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.selectCellArea(coordinates.y, coordinates.y, coordinates.x, coordinates.x);
    }

    private void selectCellArea(int startRow, int endRow, int startColumn, int endColumn) {
        this.jTableOperator.setRowSelectionAllowed(true);
        this.jTableOperator.addRowSelectionInterval(startRow, endRow);
        this.jTableOperator.setColumnSelectionAllowed(true);
        this.jTableOperator.addColumnSelectionInterval(startColumn, endColumn);
    }

    public void selectCellArea(String startRow, String endRow, String startColumn, String endColumn) {
        this.selectCellArea(Integer.valueOf(startColumn), Integer.valueOf(endColumn), Integer.valueOf(startRow), Integer.valueOf(endRow));
    }

    public void setCellValue(Object newValue, String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.setValueAt(newValue, coordinates.y, coordinates.x);
    }

    public void typeIntoCell(Object newValue, String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        this.jTableOperator.changeCellObject(coordinates.y, coordinates.x, newValue);
        this.ensureEnterIsReleased();
    }

    private void ensureEnterIsReleased() {
        KeyEvent releaseEvent = new KeyEvent(this.jTableOperator.getSource(), 402, System.currentTimeMillis(), 0, 10, '\uffff');
        SwingInvoker.postEvent(releaseEvent);
    }

    public void clearCell(String row, String columnIdentifier) {
        this.setCellValue("", row, columnIdentifier);
    }

    public void clearSelection() {
        this.jTableOperator.clearSelection();
    }

    public int getColumnCount() {
        return this.jTableOperator.getColumnCount();
    }

    public int getRowCount() {
        return this.jTableOperator.getRowCount();
    }

    public int findCellRow(String text) {
        return this.jTableOperator.findCellRow(text);
    }

    public int findCellRow(String text, String columnIdentifier) {
        int col = this.jTableOperator.findColumn(columnIdentifier);
        if (col == -1) {
            throw new RuntimeException("Column '" + columnIdentifier + " not found.");
        }
        return this.jTableOperator.findCellRow(text, col, 0);
    }

    public Object getSelectedCellValue() {
        int selectedRow = this.jTableOperator.getSelectedRow();
        int selectedColumn = this.jTableOperator.getSelectedColumn();
        return this.cellValueExtractor.textOf(selectedRow, selectedColumn);
    }

    public void callPopupMenuItemOnSelectedCells(String menuPath) {
        int selectedRow = this.jTableOperator.getSelectedRow();
        int selectedColumn = this.jTableOperator.getSelectedColumn();
        JPopupMenuOperator menuOperator = new JPopupMenuOperator(this.jTableOperator.callPopupOnCell(selectedRow, selectedColumn));
        JMenuItemOperator item = menuOperator.showMenuItem(menuPath, (Operator.StringComparator)new EqualsStringComparator());
        item.push();
    }

    public JPopupMenuOperator callPopupOnCell(String row, String columnIdentifier) {
        Point coordinates = this.findCell(row, columnIdentifier);
        return new JPopupMenuOperator(this.jTableOperator.callPopupOnCell(coordinates.y, coordinates.x));
    }

    @Override
    public Component getSource() {
        return this.jTableOperator.getSource();
    }

    public String[] getTableHeaders() {
        Enumeration<TableColumn> columns = this.jTableOperator.getTableHeader().getColumnModel().getColumns();
        ArrayList<String> results = new ArrayList<String>();
        while (columns.hasMoreElements()) {
            TableColumn tableColumn = columns.nextElement();
            results.add(tableColumn.getHeaderValue().toString());
        }
        return results.toArray(new String[0]);
    }

    public Object[] getColumnValues(String columnIdentifier) {
        Object[] columnValues = new Object[this.getRowCount()];
        for (int row = 0; row < columnValues.length; ++row) {
            Point coordinates = this.findCell(row, columnIdentifier);
            columnValues[row] = this.getValueAt(coordinates);
        }
        return columnValues;
    }

    private Object getValueAt(Point coordinates) {
        return this.cellValueExtractor.textOf(coordinates.y, coordinates.x);
    }

    protected Point findCell(String row, String columnIdentifier) {
        return this.findCell(this.asIndex(row), columnIdentifier);
    }

    protected Point findCell(int row, String columnIdentifier) {
        JTableOperator.TableCellChooser cellChooser = this.createCellChooser(row, columnIdentifier);
        Point cell = this.jTableOperator.findCell(cellChooser);
        if (this.isInvalid(cell)) {
            throw new InvalidCellException(row, columnIdentifier);
        }
        return cell;
    }

    protected boolean isInvalid(Point cell) {
        return cell.x < 0 || cell.y < 0;
    }

    protected JTableOperator.TableCellChooser createCellChooser(int row, String columnIdentifier) {
        if (this.isIndex(columnIdentifier)) {
            return new ColumnIndexTableCellChooser(row, columnIdentifier);
        }
        return new ColumnNameTableCellChooser(row, columnIdentifier);
    }

    public Map<String, Object> getCellProperties(String row, String columnIdentifier) {
        Point cell = this.findCell(row, columnIdentifier);
        Component cellComponent = this.cellValueExtractor.getCellRendererComponent(cell.y, cell.x);
        return this.propertyExtractor.extractProperties(cellComponent);
    }

    public void clickOnCell(String rowNumber, String columnIdentifier, String clickCount, String button, String[] keyModifiers) {
        Point cell = this.findCell(rowNumber, columnIdentifier);
        this.jTableOperator.clickOnCell(cell.y, cell.x, Integer.parseInt(clickCount), this.toInputEventMask(button), this.toCombinedInputEventMasks(keyModifiers));
    }

    private int toInputEventMask(String inputEventFieldName) {
        try {
            return InputEvent.class.getField(inputEventFieldName).getInt(null);
        }
        catch (NoSuchFieldException e) {
            throw new IllegalArgumentException("No field name '" + inputEventFieldName + "' in class " + InputEvent.class.getName() + ".");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private int toCombinedInputEventMasks(String[] modifierStrings) {
        int combinedInputEventMask = 0;
        if (modifierStrings.length > 0) {
            for (String modifierAsString : modifierStrings) {
                combinedInputEventMask |= this.toInputEventMask(modifierAsString);
            }
        }
        return combinedInputEventMask;
    }
}

