/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.robotframework.swing.testapp.Delay;
import org.robotframework.swing.testapp.Operation;

public class ContextMenu
extends JPopupMenu
implements ActionListener {
    private static final Map<String, Operation> commands = new HashMap<String, Operation>();
    private volatile Component operatedComponent = null;

    public ContextMenu() {
        this.setOpaque(true);
        this.setLightWeightPopupEnabled(true);
        this.setName("contextMenu");
    }

    public ContextMenu add(String text, Operation command) {
        this.add(new ContextMenuItem(text, command));
        return this;
    }

    public void show(Component invoker, int x, int y) {
        Delay.delay();
        this.operatedComponent = invoker;
        super.show(invoker, x, y);
    }

    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        commands.get(command).perform(this.operatedComponent);
    }

    private class ContextMenuItem
    extends JMenuItem {
        public ContextMenuItem(String text, Operation command) {
            super(text);
            this.setName(text.toUpperCase());
            this.addActionListener(ContextMenu.this);
            this.setActionCommand(text);
            commands.put(text, command);
        }
    }
}

