/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.robotframework.swing.testapp.ContextMenu;
import org.robotframework.swing.testapp.Operation;
import org.robotframework.swing.testapp.WithPopup;

class PopupPanel
extends JPanel {
    private final Operation showName = new Operation(){

        public void perform(Component operatedComponent) {
            JOptionPane.showMessageDialog(operatedComponent, operatedComponent.getName());
        }
    };
    private final ContextMenu popup = new ContextMenu(){
        {
            this.add("Show name", PopupPanel.this.showName);
        }
    };

    PopupPanel() {
    }

    public Component add(Component comp) {
        this.addPopupToComponentIfRequired(comp);
        return super.add(comp);
    }

    private void addPopupToComponentIfRequired(Component comp) {
        if (this.isWithPopup(comp)) {
            this.addPopupToComponent(comp);
        }
    }

    private boolean isWithPopup(Component comp) {
        return comp.getClass().isAnnotationPresent(WithPopup.class);
    }

    private void addPopupToComponent(Component comp) {
        comp.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    PopupPanel.this.popup.show((Component)e.getSource(), e.getX(), e.getY());
                }
            }
        });
    }
}

