/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.robotframework.javalib.util.KeywordNameNormalizer;
import org.robotframework.swing.testapp.TestDesktopPane;
import org.robotframework.swing.testapp.TestNonModalDialog;

public class TestMenuBar
extends JMenuBar {
    private static KeywordNameNormalizer textNormalizer = new KeywordNameNormalizer();

    public TestMenuBar() {
        this.setName("testMenuBar");
        this.add(new TestMenu("Test Menu"){
            {
                this.add(new TestMenuItem("Show Test Dialog - do not open this"){

                    public void actionPerformed(ActionEvent e) {
                        throw new RuntimeException("This menu item shouldn not be opened");
                    }
                });
                this.add(new TestMenuItem("Show Test Dialog"){

                    public void actionPerformed(ActionEvent e) {
                        JOptionPane.showMessageDialog(this, "This is an example message");
                    }
                });
                this.add(new TestMenuItem("Show Non-Modal Dialog"){

                    public void actionPerformed(ActionEvent e) {
                        new TestNonModalDialog().showDialog();
                    }
                });
                this.add(new TestMenuItem("Show Internal Frame"){

                    public void actionPerformed(ActionEvent e) {
                        TestDesktopPane.INSTANCE.showInternalFrame();
                    }
                });
                this.add(new TestMenuItem("Mutable Menu"){

                    public void actionPerformed(ActionEvent e) {
                        this.setText("Menu Item Was Pushed");
                    }
                });
                this.add(new TestMenuItem("Disabled Menu Item").setDisabled());
                this.add(new TestMenuItem("Show Test Window"){

                    public void actionPerformed(ActionEvent e) {
                        new JFrame("Test Window"){
                            {
                                this.setName("testWindow");
                                this.setDefaultCloseOperation(3);
                                this.setSize(400, 400);
                                this.setVisible(true);
                            }
                        };
                    }
                });
                this.add(new JCheckBoxMenuItem("Test menu checkbox"));
            }
        });
    }

    private static class TestMenuItem
    extends JMenuItem
    implements ActionListener {
        public TestMenuItem(String text) {
            super(text);
            this.setName(textNormalizer.normalize(text));
            this.setActionCommand(textNormalizer.normalize(text));
            this.addActionListener(this);
        }

        public JMenuItem setDisabled() {
            this.setEnabled(false);
            return this;
        }

        public void actionPerformed(ActionEvent e) {
        }
    }

    private static class TestMenu
    extends JMenu {
        public TestMenu(String text) {
            super(text);
            this.setName(textNormalizer.normalize(text));
        }
    }
}

