/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.testapp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import org.robotframework.swing.testapp.MenuItemWithCommand;

public class TestTable
extends JScrollPane {
    public TestTable(String name, Object[][] data, JTextField textField) {
        super(TestTable.createTable(name, data, textField));
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, 100);
    }

    private static JTable createTable(String name, Object[][] data, final JTextField textField) {
        JTable table = new JTable();
        table.setName(name);
        table.addMouseListener(new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.getButton() == 3) {
                    new TablePopupMenu((JTable)e.getSource(), e.getX(), e.getY());
                }
            }
        });
        table.setModel(new MyTabeModel(data));
        TableColumn col = table.getColumnModel().getColumn(0);
        String[] comboBoxValues = new String[]{"one/one", "two/one", "three/one", "four/one"};
        col.setCellEditor(new MyComboBoxEditor(comboBoxValues));
        col.setCellRenderer(new MyComboBoxRenderer(comboBoxValues));
        table.setCellSelectionEnabled(true);
        table.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                textField.setText(String.format("%s cell clicked %s times, button: %s modEx: %s", e.getComponent().getName(), e.getClickCount(), e.getButton(), e.getModifiersEx()));
            }
        });
        return table;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyTabeModel
    extends DefaultTableModel {
        private Object[][] data;

        public MyTabeModel(Object[][] data) {
            this.data = data;
            for (Object[] datarow : data) {
                this.addColumn(datarow[0], Arrays.copyOfRange(datarow, 1, datarow.length));
            }
        }

        @Override
        public Class<?> getColumnClass(int col) {
            return this.data[col][1].getClass();
        }
    }

    private static class TablePopupMenu
    extends JPopupMenu {
        private final JTable invoker;

        public TablePopupMenu(JTable invoker, int x, int y) {
            this.invoker = invoker;
            this.addMenu(this.getCellCoordinates(x, y));
            this.show(invoker, x, y);
        }

        private Point getCellCoordinates(int x, int y) {
            int columnCount = this.invoker.getModel().getColumnCount();
            int rowCount = this.invoker.getModel().getRowCount();
            int cellX = x / (this.invoker.getWidth() / columnCount);
            int cellY = y / (this.invoker.getHeight() / rowCount);
            return new Point(cellX, cellY);
        }

        private void addMenu(final Point cellCoordinates) {
            this.add(new MenuItemWithCommand("Replace text"){

                public void actionPerformed(ActionEvent e) {
                    TablePopupMenu.this.invoker.setValueAt("newValue", cellCoordinates.y, cellCoordinates.x);
                }
            });
            this.add(new JMenuItem("Disabled menuitem"){
                {
                    this.setEnabled(false);
                }
            });
            this.add(new JMenu("Submenu"){
                {
                    this.add(new JMenuItem("Disabled menuitem"){
                        {
                            this.setEnabled(false);
                        }
                    });
                    this.add(new JMenuItem("Enabled menuitem"));
                }
            });
            this.add(new MenuItemWithCommand("Replace text in selected"){

                public void actionPerformed(ActionEvent e) {
                    int[] cols = TablePopupMenu.this.invoker.getSelectedColumns();
                    int[] rows = TablePopupMenu.this.invoker.getSelectedRows();
                    for (int col : cols) {
                        for (int row : rows) {
                            TablePopupMenu.this.invoker.setValueAt("newValue", row, col);
                        }
                    }
                }
            });
            this.setOpaque(true);
            this.setLightWeightPopupEnabled(true);
            this.setName("popupMenu");
        }
    }

    public static class MyComboBoxEditor
    extends DefaultCellEditor {
        public MyComboBoxEditor(String[] items) {
            super(new JComboBox<String>(items));
        }
    }

    public static class MyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        public MyComboBoxRenderer(String[] items) {
            super(items);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelectedIndex(row);
            return this;
        }
    }
}

