/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.tree;

import java.awt.Component;
import java.awt.Point;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.robotframework.org.apache.commons.collections.CollectionUtils;
import org.robotframework.org.apache.commons.collections.Transformer;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.Waiter;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JPopupMenuOperator;
import org.robotframework.org.netbeans.jemmy.operators.JTreeOperator;
import org.robotframework.swing.common.TimeoutCopier;
import org.robotframework.swing.operator.ComponentWrapper;
import org.robotframework.swing.popup.PopupCaller;
import org.robotframework.swing.tree.NodeTextExtractor;
import org.robotframework.swing.tree.TreeIterator;
import org.robotframework.swing.tree.TreePathAction;
import org.robotframework.swing.tree.TreePathFactory;
import org.robotframework.swing.tree.TreePathWaitable;
import org.robotframework.swing.tree.TreePopupMenuOperatorFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeOperator
implements ComponentWrapper {
    protected PopupCaller popupCaller = new PopupCaller();
    protected TreePathFactory treePathFactory = new TreePathFactory(this);
    protected JTreeOperator jTreeOperator;

    public TreeOperator(ContainerOperator containerOperator, ComponentChooser componentChooser) {
        this.jTreeOperator = new JTreeOperator(containerOperator, componentChooser);
    }

    public TreeOperator(ContainerOperator containerOperator, int index) {
        this.jTreeOperator = new JTreeOperator(containerOperator, index);
    }

    public TreeOperator(JTreeOperator treeOperator) {
        this.jTreeOperator = treeOperator;
    }

    public JPopupMenu callPopupOnRow(int row) {
        this.jTreeOperator.selectRow(row);
        this.jTreeOperator.scrollToRow(row);
        Point pointToClick = this.jTreeOperator.getPointToClick(row);
        return this.popupCaller.callPopupOnComponent(this.jTreeOperator, pointToClick);
    }

    public TreePath findPath(String treePath) {
        try {
            return (TreePath)this.treePathWaiterFor(treePath).waitAction(null);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private Waiter treePathWaiterFor(String treePath) {
        Waiter waiter = new Waiter(new TreePathWaitable(this.jTreeOperator, treePath));
        waiter.setTimeouts(new TimeoutCopier(this.jTreeOperator, "JTreeOperator.WaitNextNodeTimeout").getTimeouts());
        return waiter;
    }

    public void expand(String nodeIdentifier) {
        this.expand(this.createTreePath(nodeIdentifier));
    }

    public void expand(TreePath path) {
        this.jTreeOperator.expandPath(path);
    }

    public void collapse(String nodeIdentifier) {
        this.collapse(this.createTreePath(nodeIdentifier));
    }

    public void collapse(TreePath nodeIdentifier) {
        this.jTreeOperator.collapsePath(nodeIdentifier);
    }

    public void addSelection(String nodeIdentifier) {
        this.jTreeOperator.addSelectionPath(this.createTreePath(nodeIdentifier));
    }

    public void removeSelection(String nodeIdentifier) {
        this.jTreeOperator.removeSelectionPath(this.createTreePath(nodeIdentifier));
    }

    public boolean isExpanded(String nodeIdentifier) {
        return this.isExpanded(this.createTreePath(nodeIdentifier));
    }

    public boolean isExpanded(TreePath nodeIdentifier) {
        return this.jTreeOperator.isExpanded(nodeIdentifier);
    }

    public boolean isCollapsed(String nodeIdentifier) {
        return this.isCollapsed(this.createTreePath(nodeIdentifier));
    }

    public boolean isCollapsed(TreePath nodeIdentifier) {
        return this.jTreeOperator.isCollapsed(nodeIdentifier);
    }

    public boolean isLeaf(String nodeIdentifier) {
        return this.isLeaf(this.createTreePath(nodeIdentifier));
    }

    public boolean isLeaf(TreePath nodeIdentifier) {
        TreeNode lastPathComponent = (TreeNode)nodeIdentifier.getLastPathComponent();
        return lastPathComponent.isLeaf();
    }

    public boolean isPathSelected(String nodeIdentifier) {
        return this.jTreeOperator.isPathSelected(this.createTreePath(nodeIdentifier));
    }

    public boolean isVisible(String nodeIdentifier) {
        TreePath treePath = this.createTreePath(nodeIdentifier);
        return this.jTreeOperator.isVisible(treePath);
    }

    public void clickOnNode(String nodeIdentifier, int clickCount) {
        this.jTreeOperator.clickOnPath(this.createTreePath(nodeIdentifier), clickCount);
    }

    public JPopupMenuOperator createPopupOperator(String nodeIdentifier) {
        return (JPopupMenuOperator)this.popupFactory().createOperator(nodeIdentifier);
    }

    public JPopupMenuOperator createPopupOperatorOnSelectedNodes() {
        return this.popupFactory().createOperatorBySelection();
    }

    public String getTreeNodeLabel(int index) {
        TreePath pathForRow = this.jTreeOperator.getPathForRow(index);
        return pathForRow.getLastPathComponent().toString();
    }

    public int getTreeNodeIndex(String nodePath) {
        return this.jTreeOperator.getRowForPath(this.findPath(nodePath));
    }

    @Override
    public Component getSource() {
        return this.jTreeOperator.getSource();
    }

    public TreeModel getModel() {
        return this.jTreeOperator.getModel();
    }

    public TreePath getPathForRow(int i) {
        return this.jTreeOperator.getPathForRow(i);
    }

    public int getRowCount() {
        return this.jTreeOperator.getRowCount();
    }

    public void clearSelection() {
        this.jTreeOperator.clearSelection();
    }

    public boolean isRootVisible() {
        return this.jTreeOperator.isRootVisible();
    }

    public JPopupMenu callPopupOnPath(TreePath treePath) {
        return this.jTreeOperator.callPopupOnPath(treePath);
    }

    public JPopupMenu callPopupOnPaths(TreePath[] treePaths) {
        return this.jTreeOperator.callPopupOnPaths(treePaths);
    }

    public TreePath[] getSelectionPaths() {
        return this.jTreeOperator.getSelectionPaths();
    }

    public void operateOnAllNodes(TreePathAction action) {
        this.createIterator().operateOnAllNodes(action);
    }

    public Collection<String> getTreeNodeChildNames(String nodeIdentifier) {
        final TreePath treePath = this.createTreePath(nodeIdentifier);
        return CollectionUtils.collect(this.getChildPaths(treePath), new Transformer(){

            public Object transform(Object input) {
                Object node = ((TreePath)input).getLastPathComponent();
                return new NodeTextExtractor((JTree)TreeOperator.this.getSource()).getText(node, treePath);
            }
        });
    }

    private List<TreePath> getChildPaths(TreePath treePath) {
        return Arrays.asList(this.jTreeOperator.getChildPaths(treePath));
    }

    protected TreeIterator createIterator() {
        return new TreeIterator(this.jTreeOperator);
    }

    protected TreePopupMenuOperatorFactory popupFactory() {
        return new TreePopupMenuOperatorFactory(this);
    }

    protected TreePath createTreePath(String nodeIdentifier) {
        return this.treePathFactory.createTreePath(nodeIdentifier);
    }

    public JTreeOperator getTreeOperator() {
        return this.jTreeOperator;
    }
}

