/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.gnu.regexp;

import java.io.Serializable;
import org.robotframework.gnu.regexp.CharIndexed;

public final class REMatch
implements Serializable,
Cloneable {
    private String matchedText;
    int eflags;
    int offset;
    int anchor;
    int index;
    int[] start;
    int[] end;
    REMatch next;

    public Object clone() {
        try {
            REMatch rEMatch = (REMatch)super.clone();
            rEMatch.next = null;
            rEMatch.start = (int[])this.start.clone();
            rEMatch.end = (int[])this.end.clone();
            return rEMatch;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error();
        }
    }

    void assignFrom(REMatch rEMatch) {
        this.start = rEMatch.start;
        this.end = rEMatch.end;
        this.index = rEMatch.index;
        this.next = rEMatch.next;
    }

    void finish(CharIndexed charIndexed) {
        this.start[0] = 0;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < this.end[0]) {
            stringBuffer.append(charIndexed.charAt(n));
            ++n;
        }
        this.matchedText = stringBuffer.toString();
        n = 0;
        while (n < this.start.length) {
            if (this.start[n] == -1 ^ this.end[n] == -1) {
                this.start[n] = -1;
                this.end[n] = -1;
            }
            ++n;
        }
        this.next = null;
    }

    void clear(int n) {
        this.offset = n;
        this.index = 0;
        int n2 = 0;
        while (n2 < this.start.length) {
            this.end[n2] = -1;
            this.start[n2] = -1;
            ++n2;
        }
        this.next = null;
    }

    public String toString() {
        return this.matchedText;
    }

    public int getStartIndex() {
        return this.offset + this.start[0];
    }

    public int getEndIndex() {
        return this.offset + this.end[0];
    }

    public String toString(int n) {
        if (n >= this.start.length || this.start[n] == -1) {
            return "";
        }
        return this.matchedText.substring(this.start[n], this.end[n]);
    }

    public int getSubStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : this.offset + n2;
    }

    public int getStartIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.start[n];
        return n2 == -1 ? n2 : this.offset + n2;
    }

    public int getSubEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : this.offset + n2;
    }

    public int getEndIndex(int n) {
        if (n >= this.start.length) {
            return -1;
        }
        int n2 = this.end[n];
        return n2 == -1 ? n2 : this.offset + n2;
    }

    public String substituteInto(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length() - 1) {
            if (string.charAt(n) == '$' && Character.isDigit(string.charAt(n + 1))) {
                int n2;
                if ((n2 = Character.digit(string.charAt(++n), 10)) < this.start.length) {
                    stringBuffer.append(this.toString(n2));
                }
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        if (n < string.length()) {
            stringBuffer.append(string.charAt(n));
        }
        return stringBuffer.toString();
    }

    REMatch(int n, int n2, int n3) {
        this.start = new int[n + 1];
        this.end = new int[n + 1];
        this.anchor = n2;
        this.eflags = n3;
        this.clear(n2);
    }
}

