/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.beans.annotation;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.beans.annotation.IKeywordExtractor;
import org.robotframework.javalib.keyword.DocumentedKeyword;
import org.robotframework.javalib.reflection.IKeywordInvoker;
import org.robotframework.javalib.reflection.KeywordInvoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationKeywordExtractor
implements IKeywordExtractor<DocumentedKeyword> {
    @Override
    public Map<String, DocumentedKeyword> extractKeywords(Object keywordBean) {
        Method[] methods;
        HashMap<String, DocumentedKeyword> extractedKeywords = new HashMap<String, DocumentedKeyword>();
        for (Method method : methods = keywordBean.getClass().getMethods()) {
            if (!method.isAnnotationPresent(RobotKeyword.class)) continue;
            DocumentedKeyword keyword = this.createKeyword(keywordBean, method);
            extractedKeywords.put(method.getName(), keyword);
        }
        return extractedKeywords;
    }

    IKeywordInvoker createKeywordInvoker(Object keywordBean, Method method) {
        return new KeywordInvoker(keywordBean, method);
    }

    private DocumentedKeyword createKeyword(Object keywordBean, Method method) {
        IKeywordInvoker keywordInvoker = this.createKeywordInvoker(keywordBean, method);
        return this.createKeyword(keywordInvoker);
    }

    private DocumentedKeyword createKeyword(final IKeywordInvoker keywordInvoker) {
        return new DocumentedKeyword(){

            public Object execute(Object[] arguments) {
                return keywordInvoker.invoke(arguments);
            }

            public String[] getArgumentNames() {
                return keywordInvoker.getParameterNames();
            }

            public String getDocumentation() {
                return keywordInvoker.getDocumentation();
            }
        };
    }
}

