/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.javalib.library;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.robotframework.javalib.beans.annotation.AnnotationBasedKeywordFilter;
import org.robotframework.javalib.beans.annotation.IBeanLoader;
import org.robotframework.javalib.beans.annotation.KeywordBeanLoader;
import org.robotframework.javalib.beans.common.IClassFilter;
import org.robotframework.javalib.factory.AnnotationKeywordFactory;
import org.robotframework.javalib.factory.KeywordFactory;
import org.robotframework.javalib.keyword.DocumentedKeyword;
import org.robotframework.javalib.library.KeywordDocumentationRepository;
import org.robotframework.javalib.library.KeywordFactoryBasedLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationLibrary
extends KeywordFactoryBasedLibrary<DocumentedKeyword>
implements KeywordDocumentationRepository {
    protected List<IBeanLoader> beanLoaders = new ArrayList<IBeanLoader>();
    protected IClassFilter classFilter = new AnnotationBasedKeywordFilter();
    private KeywordFactory<DocumentedKeyword> keywordFactory;

    public AnnotationLibrary() {
    }

    public AnnotationLibrary(String keywordPattern) {
        this.addKeywordPattern(keywordPattern);
    }

    public AnnotationLibrary(List<String> keywordPatterns) {
        for (String pattern : keywordPatterns) {
            this.addKeywordPattern(pattern);
        }
    }

    @Override
    protected KeywordFactory<DocumentedKeyword> createKeywordFactory() {
        this.assumeKeywordPatternIsSet();
        if (this.keywordFactory == null) {
            ArrayList<Map> keywordBeansMaps = new ArrayList<Map>();
            for (IBeanLoader beanLoader : this.beanLoaders) {
                keywordBeansMaps.add(beanLoader.loadBeanDefinitions(this.classFilter));
            }
            this.keywordFactory = new AnnotationKeywordFactory(keywordBeansMaps);
        }
        return this.keywordFactory;
    }

    @Override
    public String[] getKeywordArguments(String keywordName) {
        return this.createKeywordFactory().createKeyword(keywordName).getArgumentNames();
    }

    @Override
    public String getKeywordDocumentation(String keywordName) {
        return this.createKeywordFactory().createKeyword(keywordName).getDocumentation();
    }

    @Override
    public Object runKeyword(String keywordName, Object[] args) {
        try {
            return super.runKeyword(keywordName, args);
        }
        catch (RuntimeException e) {
            throw this.retrieveInnerException(e);
        }
    }

    public void addKeywordPattern(String keywordPattern) {
        this.beanLoaders.add(new KeywordBeanLoader(keywordPattern, Thread.currentThread().getContextClassLoader()));
    }

    private void assumeKeywordPatternIsSet() {
        if (this.beanLoaders.isEmpty()) {
            throw new IllegalStateException("Keyword pattern must be set before calling getKeywordNames.");
        }
    }

    private RuntimeException retrieveInnerException(RuntimeException e) {
        Throwable cause = e.getCause();
        if (InvocationTargetException.class.equals(cause.getClass())) {
            Throwable original = cause.getCause();
            return new RuntimeException(original.getMessage(), original);
        }
        return e;
    }
}

