/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.drivers.scrolling;

import java.awt.Adjustable;
import java.awt.Point;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.AWTScrollDriver;
import org.robotframework.org.netbeans.jemmy.drivers.scrolling.ScrollAdjuster;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.ScrollPaneOperator;

public class ScrollPaneDriver
extends AWTScrollDriver {
    private static final int CLICK_OFFSET = 5;

    public ScrollPaneDriver() {
        super(new String[]{"org.robotframework.org.netbeans.jemmy.operators.ScrollPaneOperator"});
    }

    public void scrollToMinimum(ComponentOperator oper, final int orientation) {
        final Adjustable adj = orientation == 0 ? ((ScrollPaneOperator)oper).getHAdjustable() : ((ScrollPaneOperator)oper).getVAdjustable();
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollDirection() {
                return adj.getMinimum() < adj.getValue() ? -1 : 0;
            }

            public int getScrollOrientation() {
                return orientation;
            }

            public String getDescription() {
                return "Scroll to minimum";
            }
        });
    }

    public void scrollToMaximum(ComponentOperator oper, final int orientation) {
        final Adjustable adj = orientation == 0 ? ((ScrollPaneOperator)oper).getHAdjustable() : ((ScrollPaneOperator)oper).getVAdjustable();
        this.scroll(oper, new ScrollAdjuster(){

            public int getScrollDirection() {
                return adj.getMaximum() - adj.getVisibleAmount() > adj.getValue() ? 1 : 0;
            }

            public int getScrollOrientation() {
                return orientation;
            }

            public String getDescription() {
                return "Scroll to maximum";
            }
        });
    }

    protected Point getClickPoint(ComponentOperator oper, int direction, int orientation) {
        int y;
        int x;
        if (orientation == 0) {
            int offset;
            int n = offset = ((ScrollPaneOperator)oper).isScrollbarVisible(1) ? ((ScrollPaneOperator)oper).getVScrollbarWidth() : 0;
            if (direction == 1) {
                x = oper.getWidth() - 1 - 5 - offset;
            } else if (direction == -1) {
                x = 5;
            } else {
                return null;
            }
            y = oper.getHeight() - ((ScrollPaneOperator)oper).getHScrollbarHeight() / 2;
        } else if (orientation == 1) {
            int offset;
            int n = offset = ((ScrollPaneOperator)oper).isScrollbarVisible(0) ? ((ScrollPaneOperator)oper).getHScrollbarHeight() : 0;
            if (direction == 1) {
                y = oper.getHeight() - 1 - 5 - offset;
            } else if (direction == -1) {
                y = 5;
            } else {
                return null;
            }
            x = oper.getWidth() - ((ScrollPaneOperator)oper).getVScrollbarWidth() / 2;
        } else {
            return null;
        }
        return new Point(x, y);
    }
}

