/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.operators;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Hashtable;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SingleSelectionModel;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.PopupMenuUI;
import org.robotframework.org.netbeans.jemmy.Action;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.ComponentSearcher;
import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.JemmyProperties;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.QueueTool;
import org.robotframework.org.netbeans.jemmy.TestOut;
import org.robotframework.org.netbeans.jemmy.Timeoutable;
import org.robotframework.org.netbeans.jemmy.Timeouts;
import org.robotframework.org.netbeans.jemmy.WindowWaiter;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.MenuDriver;
import org.robotframework.org.netbeans.jemmy.operators.ComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JMenuItemOperator;
import org.robotframework.org.netbeans.jemmy.operators.JMenuOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.org.netbeans.jemmy.operators.WindowOperator;

public class JPopupMenuOperator
extends JComponentOperator
implements Outputable,
Timeoutable {
    public static final String LABEL_DPROP = "Label";
    private TestOut output;
    private Timeouts timeouts;
    private MenuDriver driver = DriverManager.getMenuDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$JPopupMenu;

    public JPopupMenuOperator(JPopupMenu popup) {
        super(popup);
    }

    public JPopupMenuOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JPopupMenu)cont.waitSubComponent(new JPopupMenuFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JPopupMenuOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JPopupMenuOperator(Operator env) {
        this((JPopupMenu)JPopupMenuOperator.waitComponent(WindowOperator.waitWindow(new JPopupWindowFinder(), 0, env.getTimeouts(), env.getOutput()), new JPopupMenuFinder(), 0, env.getTimeouts(), env.getOutput()));
        this.copyEnvironment(env);
    }

    public JPopupMenuOperator(ContainerOperator cont) {
        this((JPopupMenu)JPopupMenuOperator.waitComponent(cont, (ComponentChooser)new JPopupMenuFinder(), 0));
        this.copyEnvironment(cont);
    }

    public JPopupMenuOperator() {
        this(Operator.getEnvironmentOperator());
    }

    public static JPopupMenu findJPopupMenu(Container cont, ComponentChooser chooser, int index) {
        return (JPopupMenu)JPopupMenuOperator.findComponent(cont, new JPopupMenuFinder(chooser), index);
    }

    public static JPopupMenu findJPopupMenu(Container cont, ComponentChooser chooser) {
        return JPopupMenuOperator.findJPopupMenu(cont, chooser, 0);
    }

    public static JPopupMenu waitJPopupMenu(Container cont, ComponentChooser chooser, int index) {
        return (JPopupMenu)JPopupMenuOperator.waitComponent(cont, (ComponentChooser)new JPopupMenuFinder(chooser), index);
    }

    public static JPopupMenu waitJPopupMenu(Container cont, ComponentChooser chooser) {
        return JPopupMenuOperator.waitJPopupMenu(cont, chooser, 0);
    }

    public static Window findJPopupWindow(ComponentChooser chooser) {
        new WindowWaiter();
        return WindowWaiter.getWindow(new JPopupWindowFinder(chooser));
    }

    public static Window waitJPopupWindow(ComponentChooser chooser) {
        try {
            return new WindowWaiter().waitWindow(new JPopupWindowFinder(chooser));
        }
        catch (InterruptedException e) {
            return null;
        }
    }

    public static JPopupMenuOperator waitJPopupMenu(final ComponentChooser popupChooser) {
        try {
            WindowOperator wind = new WindowOperator(new WindowWaiter().waitWindow(new ComponentChooser(){

                public boolean checkComponent(Component comp) {
                    ComponentSearcher searcher = new ComponentSearcher((Container)comp);
                    searcher.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                    return searcher.findComponent(popupChooser) != null;
                }

                public String getDescription() {
                    return "Window containing \"" + popupChooser.getDescription() + "\" popup";
                }
            }));
            return new JPopupMenuOperator(wind);
        }
        catch (InterruptedException e) {
            throw new JemmyException("Popup waiting has been interrupted", e);
        }
    }

    public static JPopupMenuOperator waitJPopupMenu(final String menuItemText) {
        return JPopupMenuOperator.waitJPopupMenu(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                if (comp instanceof JPopupMenu) {
                    ComponentSearcher searcher = new ComponentSearcher((Container)comp);
                    searcher.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                    return searcher.findComponent(new JMenuItemOperator.JMenuItemByLabelFinder(menuItemText, Operator.getDefaultStringComparator())) != null;
                }
                return false;
            }

            public String getDescription() {
                return "Popup containing \"" + menuItemText + "\" menu item";
            }
        });
    }

    public static JPopupMenu callPopup(final ComponentOperator oper, int x, int y, int mouseButton) {
        oper.makeComponentVisible();
        if (System.getProperty("java.specification.version").compareTo("1.4") > 0) {
            QueueTool qt = new QueueTool();
            qt.setOutput(oper.getOutput().createErrorOutput());
            qt.waitEmpty(10L);
            qt.waitEmpty(10L);
            qt.waitEmpty(10L);
        }
        oper.clickForPopup(x, y, mouseButton);
        oper.getTimeouts().sleep("JMenuOperator.WaitBeforePopupTimeout");
        return JPopupMenuOperator.waitJPopupMenu(JPopupMenuOperator.waitJPopupWindow(new ComponentChooser(){

            public boolean checkComponent(Component cmp) {
                Component invoker = ((JPopupMenu)cmp).getInvoker();
                return invoker == oper.getSource() || invoker instanceof Container && ((Container)invoker).isAncestorOf(oper.getSource()) || oper.getSource() instanceof Container && ((Container)oper.getSource()).isAncestorOf(invoker);
            }

            public String getDescription() {
                return "Popup menu";
            }
        }), ComponentSearcher.getTrueChooser("Popup menu"));
    }

    public static JPopupMenu callPopup(ComponentOperator oper, int x, int y) {
        return JPopupMenuOperator.callPopup(oper, x, y, JPopupMenuOperator.getPopupMouseButton());
    }

    public static JPopupMenu callPopup(Component comp, int x, int y, int mouseButton) {
        return JPopupMenuOperator.callPopup(new ComponentOperator(comp), x, y, mouseButton);
    }

    public static JPopupMenu callPopup(Component comp, int x, int y) {
        return JPopupMenuOperator.callPopup(comp, x, y, JPopupMenuOperator.getPopupMouseButton());
    }

    public static JPopupMenu callPopup(Component comp, int mouseButton) {
        ComponentOperator co = new ComponentOperator(comp);
        co.makeComponentVisible();
        co.clickForPopup(mouseButton);
        return JPopupMenuOperator.findJPopupMenu(JPopupMenuOperator.waitJPopupWindow(ComponentSearcher.getTrueChooser("Popup menu window")), ComponentSearcher.getTrueChooser("Popup menu"));
    }

    public static JPopupMenu callPopup(Component comp) {
        return JPopupMenuOperator.callPopup(comp, JPopupMenuOperator.getPopupMouseButton());
    }

    public void setOutput(TestOut out) {
        super.setOutput(out);
        this.output = out;
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void setTimeouts(Timeouts times) {
        super.setTimeouts(times);
        this.timeouts = times;
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = DriverManager.getMenuDriver(this);
    }

    public JMenuItem pushMenu(final ComponentChooser[] choosers) {
        return (JMenuItem)this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                Object result = JPopupMenuOperator.this.driver.pushMenu(JPopupMenuOperator.this, JMenuOperator.converChoosers(choosers));
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                return result;
            }

            public String getDescription() {
                return JMenuOperator.createDescription(choosers);
            }
        }, this.getTimeouts().getTimeout("JMenuOperator.PushMenuTimeout"));
    }

    public void pushMenuNoBlock(final ComponentChooser[] choosers) {
        this.produceNoBlocking(new Operator.NoBlockingAction("Menu pushing"){

            public Object doAction(Object param) {
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                Object result = JPopupMenuOperator.this.driver.pushMenu(JPopupMenuOperator.this, JMenuOperator.converChoosers(choosers));
                JPopupMenuOperator.this.getQueueTool().waitEmpty();
                return result;
            }
        });
    }

    public JMenuItem pushMenu(String[] names, Operator.StringComparator comparator) {
        return this.pushMenu(JMenuItemOperator.createChoosers(names, comparator));
    }

    public JMenuItem pushMenu(String[] names, boolean ce, boolean ccs) {
        return this.pushMenu(names, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public void pushMenuNoBlock(String[] names, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(JMenuItemOperator.createChoosers(names, comparator));
    }

    public void pushMenuNoBlock(String[] names, boolean ce, boolean ccs) {
        this.pushMenuNoBlock(names, (Operator.StringComparator)new Operator.DefaultStringComparator(ce, ccs));
    }

    public JMenuItem pushMenu(String[] names) {
        return this.pushMenu(names, this.getComparator());
    }

    public void pushMenuNoBlock(String[] names) {
        this.pushMenuNoBlock(names, this.getComparator());
    }

    public JMenuItem pushMenu(String path, String delim, Operator.StringComparator comparator) {
        return this.pushMenu(this.parseString(path, delim), comparator);
    }

    public JMenuItem pushMenu(String path, Operator.StringComparator comparator) {
        return this.pushMenu(this.parseString(path), comparator);
    }

    public JMenuItem pushMenu(String path, String delim, boolean ce, boolean ccs) {
        return this.pushMenu(this.parseString(path, delim), ce, ccs);
    }

    public void pushMenuNoBlock(String path, String delim, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(this.parseString(path, delim), comparator);
    }

    public void pushMenuNoBlock(String path, Operator.StringComparator comparator) {
        this.pushMenuNoBlock(this.parseString(path), comparator);
    }

    public void pushMenuNoBlock(String path, String delim, boolean ce, boolean ccs) {
        this.pushMenuNoBlock(this.parseString(path, delim), ce, ccs);
    }

    public JMenuItem pushMenu(String path, String delim) {
        return this.pushMenu(this.parseString(path, delim));
    }

    public JMenuItem pushMenu(String path) {
        return this.pushMenu(this.parseString(path));
    }

    public void pushMenuNoBlock(String path, String delim) {
        this.pushMenuNoBlock(this.parseString(path, delim));
    }

    public void pushMenuNoBlock(String path) {
        this.pushMenuNoBlock(this.parseString(path));
    }

    public JMenuItemOperator[] showMenuItems(ComponentChooser[] choosers) {
        if (choosers == null || choosers.length == 0) {
            return JMenuItemOperator.getMenuItems((MenuElement)((Object)this.getSource()), (Operator)this);
        }
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(choosers), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] path, Operator.StringComparator comparator) {
        if (path == null || path.length == 0) {
            return JMenuItemOperator.getMenuItems((MenuElement)((Object)this.getSource()), (Operator)this);
        }
        return JMenuItemOperator.getMenuItems((JMenu)this.pushMenu(path, comparator), (Operator)this);
    }

    public JMenuItemOperator[] showMenuItems(String[] path) {
        return this.showMenuItems(path, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String path, String delim, Operator.StringComparator comparator) {
        return this.showMenuItems(this.parseString(path, delim), comparator);
    }

    public JMenuItemOperator[] showMenuItems(String path, Operator.StringComparator comparator) {
        return this.showMenuItems(this.parseString(path), comparator);
    }

    public JMenuItemOperator[] showMenuItems(String path, String delim) {
        return this.showMenuItems(path, delim, this.getComparator());
    }

    public JMenuItemOperator[] showMenuItems(String path) {
        return this.showMenuItems(path, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(ComponentChooser[] choosers) {
        ContainerOperator menuCont;
        ComponentChooser[] parentPath = this.getParentPath(choosers);
        if (parentPath.length > 0) {
            JMenu menu = (JMenu)this.pushMenu(this.getParentPath(choosers));
            menuCont = new ContainerOperator(menu.getPopupMenu());
            menuCont.copyEnvironment(this);
        } else {
            menuCont = this;
        }
        JMenuItemOperator result = new JMenuItemOperator(menuCont, choosers[choosers.length - 1]);
        result.copyEnvironment(this);
        return result;
    }

    public JMenuItemOperator showMenuItem(String[] path, Operator.StringComparator comparator) {
        ContainerOperator menuCont;
        String[] parentPath = this.getParentPath(path);
        if (parentPath.length > 0) {
            JMenu menu = (JMenu)this.pushMenu(this.getParentPath(path), comparator);
            menuCont = new ContainerOperator(menu.getPopupMenu());
            menuCont.copyEnvironment(this);
        } else {
            menuCont = this;
        }
        JMenuItemOperator result = new JMenuItemOperator(menuCont, path[path.length - 1]);
        result.copyEnvironment(this);
        return result;
    }

    public JMenuItemOperator showMenuItem(String[] path) {
        return this.showMenuItem(path, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String path, String delim, Operator.StringComparator comparator) {
        return this.showMenuItem(this.parseString(path, delim), comparator);
    }

    public JMenuItemOperator showMenuItem(String path, Operator.StringComparator comparator) {
        return this.showMenuItem(this.parseString(path), comparator);
    }

    public JMenuItemOperator showMenuItem(String path, String delim) {
        return this.showMenuItem(path, delim, this.getComparator());
    }

    public JMenuItemOperator showMenuItem(String path) {
        return this.showMenuItem(path, this.getComparator());
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        if (((JPopupMenu)this.getSource()).getLabel() != null) {
            result.put(LABEL_DPROP, ((JPopupMenu)this.getSource()).getLabel());
        }
        return result;
    }

    public JMenuItem add(final String string) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).add(string);
            }
        });
    }

    public JMenuItem add(final javax.swing.Action action) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).add(action);
            }
        });
    }

    public JMenuItem add(final JMenuItem jMenuItem) {
        return (JMenuItem)this.runMapping(new Operator.MapAction("add"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).add(jMenuItem);
            }
        });
    }

    public void addPopupMenuListener(final PopupMenuListener popupMenuListener) {
        this.runMapping(new Operator.MapVoidAction("addPopupMenuListener"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).addPopupMenuListener(popupMenuListener);
            }
        });
    }

    public void addSeparator() {
        this.runMapping(new Operator.MapVoidAction("addSeparator"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).addSeparator();
            }
        });
    }

    public int getComponentIndex(final Component component) {
        return this.runMapping(new Operator.MapIntegerAction("getComponentIndex"){

            public int map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getComponentIndex(component);
            }
        });
    }

    public Component getInvoker() {
        return (Component)this.runMapping(new Operator.MapAction("getInvoker"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getInvoker();
            }
        });
    }

    public String getLabel() {
        return (String)this.runMapping(new Operator.MapAction("getLabel"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getLabel();
            }
        });
    }

    public Insets getMargin() {
        return (Insets)this.runMapping(new Operator.MapAction("getMargin"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getMargin();
            }
        });
    }

    public SingleSelectionModel getSelectionModel() {
        return (SingleSelectionModel)this.runMapping(new Operator.MapAction("getSelectionModel"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getSelectionModel();
            }
        });
    }

    public MenuElement[] getSubElements() {
        return (MenuElement[])this.runMapping(new Operator.MapAction("getSubElements"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getSubElements();
            }
        });
    }

    public PopupMenuUI getUI() {
        return (PopupMenuUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).getUI();
            }
        });
    }

    public void insert(final Component component, final int i) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).insert(component, i);
            }
        });
    }

    public void insert(final javax.swing.Action action, final int i) {
        this.runMapping(new Operator.MapVoidAction("insert"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).insert(action, i);
            }
        });
    }

    public boolean isBorderPainted() {
        return this.runMapping(new Operator.MapBooleanAction("isBorderPainted"){

            public boolean map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).isBorderPainted();
            }
        });
    }

    public boolean isLightWeightPopupEnabled() {
        return this.runMapping(new Operator.MapBooleanAction("isLightWeightPopupEnabled"){

            public boolean map() {
                return ((JPopupMenu)JPopupMenuOperator.this.getSource()).isLightWeightPopupEnabled();
            }
        });
    }

    public void menuSelectionChanged(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("menuSelectionChanged"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).menuSelectionChanged(b);
            }
        });
    }

    public void pack() {
        this.runMapping(new Operator.MapVoidAction("pack"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).pack();
            }
        });
    }

    public void processKeyEvent(final KeyEvent keyEvent, final MenuElement[] menuElement, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processKeyEvent"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).processKeyEvent(keyEvent, menuElement, menuSelectionManager);
            }
        });
    }

    public void processMouseEvent(final MouseEvent mouseEvent, final MenuElement[] menuElement, final MenuSelectionManager menuSelectionManager) {
        this.runMapping(new Operator.MapVoidAction("processMouseEvent"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).processMouseEvent(mouseEvent, menuElement, menuSelectionManager);
            }
        });
    }

    public void removePopupMenuListener(final PopupMenuListener popupMenuListener) {
        this.runMapping(new Operator.MapVoidAction("removePopupMenuListener"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).removePopupMenuListener(popupMenuListener);
            }
        });
    }

    public void setBorderPainted(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setBorderPainted"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setBorderPainted(b);
            }
        });
    }

    public void setInvoker(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setInvoker"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setInvoker(component);
            }
        });
    }

    public void setLabel(final String string) {
        this.runMapping(new Operator.MapVoidAction("setLabel"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setLabel(string);
            }
        });
    }

    public void setLightWeightPopupEnabled(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setLightWeightPopupEnabled"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setLightWeightPopupEnabled(b);
            }
        });
    }

    public void setPopupSize(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("setPopupSize"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setPopupSize(i, i1);
            }
        });
    }

    public void setPopupSize(final Dimension dimension) {
        this.runMapping(new Operator.MapVoidAction("setPopupSize"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setPopupSize(dimension);
            }
        });
    }

    public void setSelected(final Component component) {
        this.runMapping(new Operator.MapVoidAction("setSelected"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setSelected(component);
            }
        });
    }

    public void setSelectionModel(final SingleSelectionModel singleSelectionModel) {
        this.runMapping(new Operator.MapVoidAction("setSelectionModel"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setSelectionModel(singleSelectionModel);
            }
        });
    }

    public void setUI(final PopupMenuUI popupMenuUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).setUI(popupMenuUI);
            }
        });
    }

    public void show(final Component component, final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("show"){

            public void map() {
                ((JPopupMenu)JPopupMenuOperator.this.getSource()).show(component, i, i1);
            }
        });
    }

    static {
        JMenuOperator.class.getName();
    }

    public static class JPopupWindowFinder
    implements ComponentChooser {
        ComponentChooser subFinder;
        ComponentChooser ppFinder;

        public JPopupWindowFinder(ComponentChooser sf) {
            this.subFinder = new JPopupMenuFinder(sf);
            this.ppFinder = new ComponentChooser(){

                public boolean checkComponent(Component comp) {
                    return comp.isShowing() && comp.isVisible() && JPopupWindowFinder.this.subFinder.checkComponent(comp);
                }

                public String getDescription() {
                    return JPopupWindowFinder.this.subFinder.getDescription();
                }
            };
        }

        public JPopupWindowFinder() {
            this(ComponentSearcher.getTrueChooser("Any JPopupWindow"));
        }

        public boolean checkComponent(Component comp) {
            if (comp.isShowing() && comp instanceof Window) {
                ComponentSearcher cs = new ComponentSearcher((Container)comp);
                cs.setOutput(JemmyProperties.getCurrentOutput().createErrorOutput());
                return cs.findComponent(this.ppFinder) != null;
            }
            return false;
        }

        public String getDescription() {
            return this.subFinder.getDescription();
        }
    }

    public static class JPopupMenuFinder
    extends Operator.Finder {
        public JPopupMenuFinder(ComponentChooser sf) {
            super(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = JPopupMenuOperator.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu, sf);
        }

        public JPopupMenuFinder() {
            super(class$javax$swing$JPopupMenu == null ? (class$javax$swing$JPopupMenu = JPopupMenuOperator.class$("javax.swing.JPopupMenu")) : class$javax$swing$JPopupMenu);
        }

        public boolean checkComponent(Component comp) {
            return comp.isShowing() && super.checkComponent(comp);
        }
    }
}

