/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.org.netbeans.jemmy.operators;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Hashtable;
import javax.swing.JScrollPane;
import javax.swing.event.CaretListener;
import javax.swing.plaf.TextUI;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.robotframework.org.netbeans.jemmy.Action;
import org.robotframework.org.netbeans.jemmy.ComponentChooser;
import org.robotframework.org.netbeans.jemmy.ComponentSearcher;
import org.robotframework.org.netbeans.jemmy.JemmyException;
import org.robotframework.org.netbeans.jemmy.JemmyInputException;
import org.robotframework.org.netbeans.jemmy.Outputable;
import org.robotframework.org.netbeans.jemmy.TestOut;
import org.robotframework.org.netbeans.jemmy.Timeoutable;
import org.robotframework.org.netbeans.jemmy.Timeouts;
import org.robotframework.org.netbeans.jemmy.drivers.DriverManager;
import org.robotframework.org.netbeans.jemmy.drivers.TextDriver;
import org.robotframework.org.netbeans.jemmy.operators.ContainerOperator;
import org.robotframework.org.netbeans.jemmy.operators.JComponentOperator;
import org.robotframework.org.netbeans.jemmy.operators.JScrollPaneOperator;
import org.robotframework.org.netbeans.jemmy.operators.Operator;
import org.robotframework.org.netbeans.jemmy.util.EmptyVisualizer;

public class JTextComponentOperator
extends JComponentOperator
implements Timeoutable,
Outputable {
    public static final String TEXT_DPROP = "Text";
    public static final String SELECTED_TEXT_DPROP = "Selected text";
    public static final String IS_EDITABLE_DPROP = "Editable";
    private static final long PUSH_KEY_TIMEOUT = 0L;
    private static final long BETWEEN_KEYS_TIMEOUT = 0L;
    private static final long CHANGE_CARET_POSITION_TIMEOUT = 60000L;
    private static final long TYPE_TEXT_TIMEOUT = 60000L;
    private Timeouts timeouts;
    private TestOut output;
    protected int modifiersPressed = 0;
    private TextDriver driver = DriverManager.getTextDriver(this.getClass());
    static /* synthetic */ Class class$javax$swing$text$JTextComponent;

    public JTextComponentOperator(JTextComponent b) {
        super(b);
    }

    public JTextComponentOperator(ContainerOperator cont, ComponentChooser chooser, int index) {
        this((JTextComponent)cont.waitSubComponent(new JTextComponentFinder(chooser), index));
        this.copyEnvironment(cont);
    }

    public JTextComponentOperator(ContainerOperator cont, ComponentChooser chooser) {
        this(cont, chooser, 0);
    }

    public JTextComponentOperator(ContainerOperator cont, String text, int index) {
        this((JTextComponent)JTextComponentOperator.waitComponent(cont, (ComponentChooser)new JTextComponentByTextFinder(text, cont.getComparator()), index));
        this.copyEnvironment(cont);
    }

    public JTextComponentOperator(ContainerOperator cont, String text) {
        this(cont, text, 0);
    }

    public JTextComponentOperator(ContainerOperator cont, int index) {
        this((JTextComponent)JTextComponentOperator.waitComponent(cont, (ComponentChooser)new JTextComponentFinder(), index));
        this.copyEnvironment(cont);
    }

    public JTextComponentOperator(ContainerOperator cont) {
        this(cont, 0);
    }

    public static JTextComponent findJTextComponent(Container cont, ComponentChooser chooser, int index) {
        return (JTextComponent)JTextComponentOperator.findComponent(cont, new JTextComponentFinder(chooser), index);
    }

    public static JTextComponent findJTextComponent(Container cont, ComponentChooser chooser) {
        return JTextComponentOperator.findJTextComponent(cont, chooser, 0);
    }

    public static JTextComponent findJTextComponent(Container cont, String text, boolean ce, boolean ccs, int index) {
        return JTextComponentOperator.findJTextComponent(cont, new JTextComponentByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTextComponent findJTextComponent(Container cont, String text, boolean ce, boolean ccs) {
        return JTextComponentOperator.findJTextComponent(cont, text, ce, ccs, 0);
    }

    public static JTextComponent waitJTextComponent(Container cont, ComponentChooser chooser, int index) {
        return (JTextComponent)JTextComponentOperator.waitComponent(cont, (ComponentChooser)new JTextComponentFinder(chooser), index);
    }

    public static JTextComponent waitJTextComponent(Container cont, ComponentChooser chooser) {
        return JTextComponentOperator.waitJTextComponent(cont, chooser, 0);
    }

    public static JTextComponent waitJTextComponent(Container cont, String text, boolean ce, boolean ccs, int index) {
        return JTextComponentOperator.waitJTextComponent(cont, new JTextComponentByTextFinder(text, new Operator.DefaultStringComparator(ce, ccs)), index);
    }

    public static JTextComponent waitJTextComponent(Container cont, String text, boolean ce, boolean ccs) {
        return JTextComponentOperator.waitJTextComponent(cont, text, ce, ccs, 0);
    }

    public void setTimeouts(Timeouts times) {
        this.timeouts = times;
        this.timeouts.setTimeout("ComponentOperator.PushKeyTimeout", this.timeouts.getTimeout("JTextComponentOperator.PushKeyTimeout"));
        super.setTimeouts(this.timeouts);
    }

    public Timeouts getTimeouts() {
        return this.timeouts;
    }

    public void setOutput(TestOut out) {
        this.output = out;
        super.setOutput(this.output.createErrorOutput());
    }

    public TestOut getOutput() {
        return this.output;
    }

    public void copyEnvironment(Operator anotherOperator) {
        super.copyEnvironment(anotherOperator);
        this.driver = (TextDriver)DriverManager.getDriver("drivers.text", this.getClass(), anotherOperator.getProperties());
    }

    public int getPositionByText(String text, TextChooser tChooser, int index) {
        this.output.printLine("Find " + tChooser.getDescription() + "\"" + text + "\" text in text component\n    : " + this.toStringSource());
        this.output.printGolden("Find " + tChooser.getDescription() + "\"" + text + "\" text in text component");
        String allText = this.getDisplayedText();
        Document doc = this.getDocument();
        int position = 0;
        int ind = 0;
        while ((position = allText.indexOf(text, position)) >= 0) {
            if (tChooser.checkPosition(doc, position)) {
                if (ind == index) {
                    return position;
                }
                ++ind;
            }
            position += text.length();
        }
        return -1;
    }

    public int getPositionByText(String text, TextChooser tChooser) {
        return this.getPositionByText(text, tChooser, 0);
    }

    public int getPositionByText(String text, int index) {
        return this.getPositionByText(text, new TextChooser(){

            public boolean checkPosition(Document doc, int offset) {
                return true;
            }

            public String getDescription() {
                return "any";
            }
        }, index);
    }

    public int getPositionByText(String text) {
        return this.getPositionByText(text, 0);
    }

    public void enterText(final String text) {
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JTextComponentOperator.this.driver.enterText(JTextComponentOperator.this, text);
                return null;
            }

            public String getDescription() {
                return "Text entering";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
    }

    public void changeCaretPosition(final int position) {
        this.output.printLine("Change caret position to " + Integer.toString(position));
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JTextComponentOperator.this.driver.changeCaretPosition(JTextComponentOperator.this, position);
                return null;
            }

            public String getDescription() {
                return "Caret moving";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.ChangeCaretPositionTimeout"));
        if (this.getVerification()) {
            this.waitCaretPosition(position);
        }
    }

    public void changeCaretPosition(String text, int index, boolean before) {
        this.output.printLine("Put caret " + (before ? "before" : "after") + " " + Integer.toString(index) + "'th instance of \"" + text + "\" text");
        this.makeComponentVisible();
        int offset = this.getPositionByText(text, index);
        if (offset == -1) {
            throw new NoSuchTextException(text);
        }
        offset = before ? offset : offset + text.length();
        this.changeCaretPosition(offset);
    }

    public void changeCaretPosition(String text, boolean before) {
        this.changeCaretPosition(text, 0, before);
    }

    public void typeText(final String text, final int caretPosition) {
        this.output.printLine("Typing text \"" + text + "\" from " + Integer.toString(caretPosition) + " position " + "in text component\n    : " + this.toStringSource());
        this.output.printGolden("Typing text \"" + text + "\" in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JTextComponentOperator.this.driver.typeText(JTextComponentOperator.this, text, caretPosition);
                return null;
            }

            public String getDescription() {
                return "Text typing";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
        if (this.getVerification()) {
            this.waitText(text, -1);
        }
    }

    public void typeText(String text) {
        this.typeText(text, this.getCaretPosition());
    }

    public void selectText(final int startPosition, final int finalPosition) {
        this.output.printLine("Select text from " + Integer.toString(startPosition) + " to " + Integer.toString(finalPosition) + " in text component\n    : " + this.toStringSource());
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JTextComponentOperator.this.driver.selectText(JTextComponentOperator.this, startPosition, finalPosition);
                return null;
            }

            public String getDescription() {
                return "Text selecting";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
    }

    public void selectText(String text, int index) {
        this.output.printLine("Select " + Integer.toString(index) + "'th instance of \"" + text + "\" text in component\n    : " + this.toStringSource());
        this.makeComponentVisible();
        int start = this.getPositionByText(text, index);
        if (start == -1) {
            throw new NoSuchTextException(text);
        }
        this.selectText(start, start + text.length());
    }

    public void selectText(String text) {
        this.selectText(text, 0);
    }

    public void clearText() {
        this.output.printLine("Clearing text in text component\n    : " + this.toStringSource());
        this.output.printGolden("Clearing text in text component");
        this.makeComponentVisible();
        this.produceTimeRestricted(new Action(){

            public Object launch(Object obj) {
                JTextComponentOperator.this.driver.clearText(JTextComponentOperator.this);
                return null;
            }

            public String getDescription() {
                return "Text clearing";
            }
        }, this.getTimeouts().getTimeout("JTextComponentOperator.TypeTextTimeout"));
    }

    public void scrollToPosition(int position) {
        this.output.printTrace("Scroll JTextComponent to " + Integer.toString(position) + " position\n    : " + this.toStringSource());
        this.output.printGolden("Scroll JTextComponent to " + Integer.toString(position) + " position");
        this.makeComponentVisible();
        JScrollPane scroll = (JScrollPane)this.getContainer(new JScrollPaneOperator.JScrollPaneFinder(ComponentSearcher.getTrueChooser("JScrollPane")));
        if (scroll == null) {
            return;
        }
        JScrollPaneOperator scroller = new JScrollPaneOperator(scroll);
        scroller.copyEnvironment(this);
        scroller.setVisualizer(new EmptyVisualizer());
        Rectangle rect = this.modelToView(position);
        scroller.scrollToComponentRectangle(this.getSource(), (int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public String getDisplayedText() {
        try {
            Document doc = this.getDocument();
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            throw new JemmyException("Exception during text operation with\n    : " + this.toStringSource(), e);
        }
    }

    public void waitText(final String text, final int position) {
        this.getOutput().printLine("Wait \"" + text + "\" text starting from " + Integer.toString(position) + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + text + "\" text starting from " + Integer.toString(position) + " position");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                String alltext = JTextComponentOperator.this.getDisplayedText();
                if (position >= 0) {
                    if (position + text.length() <= alltext.length()) {
                        return alltext.substring(position, position + text.length()).equals(text);
                    }
                    return false;
                }
                return alltext.indexOf(text) >= 0;
            }

            public String getDescription() {
                return "Has \"" + text + "\" text starting from " + Integer.toString(position) + " position";
            }
        });
    }

    public void waitText(String text) {
        this.getOutput().printLine("Wait \"" + text + "\" text in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait \"" + text + "\" text");
        this.waitState(new JTextComponentByTextFinder(text, this.getComparator()));
    }

    public void waitCaretPosition(final int position) {
        this.getOutput().printLine("Wait caret to be at \"" + Integer.toString(position) + " position in component \n    : " + this.toStringSource());
        this.getOutput().printGolden("Wait caret to be at \"" + Integer.toString(position) + " position");
        this.waitState(new ComponentChooser(){

            public boolean checkComponent(Component comp) {
                return JTextComponentOperator.this.getCaretPosition() == position;
            }

            public String getDescription() {
                return "Has caret at " + Integer.toString(position) + " position";
            }
        });
    }

    public Hashtable getDump() {
        Hashtable result = super.getDump();
        result.put(TEXT_DPROP, ((JTextComponent)this.getSource()).getText());
        if (((JTextComponent)this.getSource()).getSelectedText() != null && !((JTextComponent)this.getSource()).getSelectedText().equals("")) {
            result.put(SELECTED_TEXT_DPROP, ((JTextComponent)this.getSource()).getSelectedText());
        }
        result.put(IS_EDITABLE_DPROP, ((JTextComponent)this.getSource()).isEditable() ? "true" : "false");
        return result;
    }

    public void addCaretListener(final CaretListener caretListener) {
        this.runMapping(new Operator.MapVoidAction("addCaretListener"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).addCaretListener(caretListener);
            }
        });
    }

    public void copy() {
        this.runMapping(new Operator.MapVoidAction("copy"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).copy();
            }
        });
    }

    public void cut() {
        this.runMapping(new Operator.MapVoidAction("cut"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).cut();
            }
        });
    }

    public javax.swing.Action[] getActions() {
        return (javax.swing.Action[])this.runMapping(new Operator.MapAction("getActions"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getActions();
            }
        });
    }

    public Caret getCaret() {
        return (Caret)this.runMapping(new Operator.MapAction("getCaret"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getCaret();
            }
        });
    }

    public Color getCaretColor() {
        return (Color)this.runMapping(new Operator.MapAction("getCaretColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getCaretColor();
            }
        });
    }

    public int getCaretPosition() {
        return this.runMapping(new Operator.MapIntegerAction("getCaretPosition"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getCaretPosition();
            }
        });
    }

    public Color getDisabledTextColor() {
        return (Color)this.runMapping(new Operator.MapAction("getDisabledTextColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getDisabledTextColor();
            }
        });
    }

    public Document getDocument() {
        return (Document)this.runMapping(new Operator.MapAction("getDocument"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getDocument();
            }
        });
    }

    public char getFocusAccelerator() {
        return this.runMapping(new Operator.MapCharacterAction("getFocusAccelerator"){

            public char map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getFocusAccelerator();
            }
        });
    }

    public Highlighter getHighlighter() {
        return (Highlighter)this.runMapping(new Operator.MapAction("getHighlighter"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getHighlighter();
            }
        });
    }

    public Keymap getKeymap() {
        return (Keymap)this.runMapping(new Operator.MapAction("getKeymap"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getKeymap();
            }
        });
    }

    public Insets getMargin() {
        return (Insets)this.runMapping(new Operator.MapAction("getMargin"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getMargin();
            }
        });
    }

    public Dimension getPreferredScrollableViewportSize() {
        return (Dimension)this.runMapping(new Operator.MapAction("getPreferredScrollableViewportSize"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getPreferredScrollableViewportSize();
            }
        });
    }

    public int getScrollableBlockIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableBlockIncrement"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableBlockIncrement(rectangle, i, i1);
            }
        });
    }

    public boolean getScrollableTracksViewportHeight() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportHeight"){

            public boolean map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableTracksViewportHeight();
            }
        });
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.runMapping(new Operator.MapBooleanAction("getScrollableTracksViewportWidth"){

            public boolean map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableTracksViewportWidth();
            }
        });
    }

    public int getScrollableUnitIncrement(final Rectangle rectangle, final int i, final int i1) {
        return this.runMapping(new Operator.MapIntegerAction("getScrollableUnitIncrement"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getScrollableUnitIncrement(rectangle, i, i1);
            }
        });
    }

    public String getSelectedText() {
        return (String)this.runMapping(new Operator.MapAction("getSelectedText"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectedText();
            }
        });
    }

    public Color getSelectedTextColor() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectedTextColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectedTextColor();
            }
        });
    }

    public Color getSelectionColor() {
        return (Color)this.runMapping(new Operator.MapAction("getSelectionColor"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectionColor();
            }
        });
    }

    public int getSelectionEnd() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionEnd"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectionEnd();
            }
        });
    }

    public int getSelectionStart() {
        return this.runMapping(new Operator.MapIntegerAction("getSelectionStart"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getSelectionStart();
            }
        });
    }

    public String getText() {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getText();
            }
        });
    }

    public String getText(final int i, final int i1) {
        return (String)this.runMapping(new Operator.MapAction("getText"){

            public Object map() throws BadLocationException {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getText(i, i1);
            }
        });
    }

    public TextUI getUI() {
        return (TextUI)this.runMapping(new Operator.MapAction("getUI"){

            public Object map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).getUI();
            }
        });
    }

    public boolean isEditable() {
        return this.runMapping(new Operator.MapBooleanAction("isEditable"){

            public boolean map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).isEditable();
            }
        });
    }

    public Rectangle modelToView(final int i) {
        return (Rectangle)this.runMapping(new Operator.MapAction("modelToView"){

            public Object map() throws BadLocationException {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).modelToView(i);
            }
        });
    }

    public void moveCaretPosition(final int i) {
        this.runMapping(new Operator.MapVoidAction("moveCaretPosition"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).moveCaretPosition(i);
            }
        });
    }

    public void paste() {
        this.runMapping(new Operator.MapVoidAction("paste"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).paste();
            }
        });
    }

    public void read(final Reader reader, final Object object) {
        this.runMapping(new Operator.MapVoidAction("read"){

            public void map() throws IOException {
                ((JTextComponent)JTextComponentOperator.this.getSource()).read(reader, object);
            }
        });
    }

    public void removeCaretListener(final CaretListener caretListener) {
        this.runMapping(new Operator.MapVoidAction("removeCaretListener"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).removeCaretListener(caretListener);
            }
        });
    }

    public void replaceSelection(final String string) {
        this.runMapping(new Operator.MapVoidAction("replaceSelection"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).replaceSelection(string);
            }
        });
    }

    public void select(final int i, final int i1) {
        this.runMapping(new Operator.MapVoidAction("select"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).select(i, i1);
            }
        });
    }

    public void selectAll() {
        this.runMapping(new Operator.MapVoidAction("selectAll"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).selectAll();
            }
        });
    }

    public void setCaret(final Caret caret) {
        this.runMapping(new Operator.MapVoidAction("setCaret"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setCaret(caret);
            }
        });
    }

    public void setCaretColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setCaretColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setCaretColor(color);
            }
        });
    }

    public void setCaretPosition(final int i) {
        this.runMapping(new Operator.MapVoidAction("setCaretPosition"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setCaretPosition(i);
            }
        });
    }

    public void setDisabledTextColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setDisabledTextColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setDisabledTextColor(color);
            }
        });
    }

    public void setDocument(final Document document) {
        this.runMapping(new Operator.MapVoidAction("setDocument"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setDocument(document);
            }
        });
    }

    public void setEditable(final boolean b) {
        this.runMapping(new Operator.MapVoidAction("setEditable"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setEditable(b);
            }
        });
    }

    public void setFocusAccelerator(final char c) {
        this.runMapping(new Operator.MapVoidAction("setFocusAccelerator"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setFocusAccelerator(c);
            }
        });
    }

    public void setHighlighter(final Highlighter highlighter) {
        this.runMapping(new Operator.MapVoidAction("setHighlighter"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setHighlighter(highlighter);
            }
        });
    }

    public void setKeymap(final Keymap keymap) {
        this.runMapping(new Operator.MapVoidAction("setKeymap"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setKeymap(keymap);
            }
        });
    }

    public void setMargin(final Insets insets) {
        this.runMapping(new Operator.MapVoidAction("setMargin"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setMargin(insets);
            }
        });
    }

    public void setSelectedTextColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectedTextColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectedTextColor(color);
            }
        });
    }

    public void setSelectionColor(final Color color) {
        this.runMapping(new Operator.MapVoidAction("setSelectionColor"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectionColor(color);
            }
        });
    }

    public void setSelectionEnd(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionEnd"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectionEnd(i);
            }
        });
    }

    public void setSelectionStart(final int i) {
        this.runMapping(new Operator.MapVoidAction("setSelectionStart"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setSelectionStart(i);
            }
        });
    }

    public void setText(final String string) {
        this.runMapping(new Operator.MapVoidAction("setText"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setText(string);
            }
        });
    }

    public void setUI(final TextUI textUI) {
        this.runMapping(new Operator.MapVoidAction("setUI"){

            public void map() {
                ((JTextComponent)JTextComponentOperator.this.getSource()).setUI(textUI);
            }
        });
    }

    public int viewToModel(final Point point) {
        return this.runMapping(new Operator.MapIntegerAction("viewToModel"){

            public int map() {
                return ((JTextComponent)JTextComponentOperator.this.getSource()).viewToModel(point);
            }
        });
    }

    public void write(final Writer writer) {
        this.runMapping(new Operator.MapVoidAction("write"){

            public void map() throws IOException {
                ((JTextComponent)JTextComponentOperator.this.getSource()).write(writer);
            }
        });
    }

    static {
        Timeouts.initDefault("JTextComponentOperator.PushKeyTimeout", 0L);
        Timeouts.initDefault("JTextComponentOperator.BetweenKeysTimeout", 0L);
        Timeouts.initDefault("JTextComponentOperator.ChangeCaretPositionTimeout", 60000L);
        Timeouts.initDefault("JTextComponentOperator.TypeTextTimeout", 60000L);
    }

    public static class JTextComponentFinder
    extends Operator.Finder {
        public JTextComponentFinder(ComponentChooser sf) {
            super(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = JTextComponentOperator.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent, sf);
        }

        public JTextComponentFinder() {
            super(class$javax$swing$text$JTextComponent == null ? (class$javax$swing$text$JTextComponent = JTextComponentOperator.class$("javax.swing.text.JTextComponent")) : class$javax$swing$text$JTextComponent);
        }
    }

    public static class JTextComponentByTextFinder
    implements ComponentChooser {
        String label;
        Operator.StringComparator comparator;

        public JTextComponentByTextFinder(String lb, Operator.StringComparator comparator) {
            this.label = lb;
            this.comparator = comparator;
        }

        public JTextComponentByTextFinder(String lb) {
            this(lb, Operator.getDefaultStringComparator());
        }

        public boolean checkComponent(Component comp) {
            if (comp instanceof JTextComponent && ((JTextComponent)comp).getText() != null) {
                return this.comparator.equals(((JTextComponent)comp).getText(), this.label);
            }
            return false;
        }

        public String getDescription() {
            return "JTextComponent with text \"" + this.label + "\"";
        }
    }

    public static interface TextChooser {
        public boolean checkPosition(Document var1, int var2);

        public String getDescription();
    }

    public class NoSuchTextException
    extends JemmyInputException {
        public NoSuchTextException(String text) {
            super("No such text as \"" + text + "\"", JTextComponentOperator.this.getSource());
        }
    }
}

