/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.context;

import java.awt.Component;
import org.robotframework.org.junit.Assert;
import org.robotframework.swing.context.Context;
import org.robotframework.swing.context.ContextVerifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContextVerifier
implements ContextVerifier {
    private final String errorMessage;

    public AbstractContextVerifier(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public void verifyContext() {
        Class<? extends Component>[] expectedClasses;
        for (Class<? extends Component> expectedClass : expectedClasses = this.getExpectedClasses()) {
            if (!expectedClass.isAssignableFrom(this.contextClass())) continue;
            return;
        }
        Assert.fail(this.errorMessage + " Current context is " + this.contextClass().getName());
    }

    protected abstract Class<? extends Component>[] getExpectedClasses();

    private Class<? extends Component> contextClass() {
        return Context.getContext().getSource().getClass();
    }
}

