/*
 * Decompiled with CFR 0.152.
 */
package org.robotframework.swing.keyword.menu;

import javax.swing.JCheckBoxMenuItem;
import org.robotframework.javalib.annotation.ArgumentNames;
import org.robotframework.javalib.annotation.RobotKeyword;
import org.robotframework.javalib.annotation.RobotKeywords;
import org.robotframework.org.junit.Assert;
import org.robotframework.org.netbeans.jemmy.operators.JCheckBoxMenuItemOperator;
import org.robotframework.org.netbeans.jemmy.operators.JMenuItemOperator;
import org.robotframework.swing.keyword.window.WindowKeywords;
import org.robotframework.swing.menu.MenuSupport;

@RobotKeywords
public class MenuCheckboxKeywords
extends MenuSupport {
    private WindowKeywords windowKeywords = new WindowKeywords();

    @RobotKeyword(value="Fails if checkbox menu item is not checked in the opened window that was opened first.\n\nExample:\n| Main Menu Item Should Be Checked | _Tools|My Checkbox_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void mainMenuItemShouldBeChecked(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuItemShouldBeChecked(menuPath);
    }

    @RobotKeyword(value="Fails if checkbox menu item is checked in the opened window that was opened first.\n\nExample:\n| Main Menu Item Should Not Be Checked | _Tools|My Checkbox_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void mainMenuItemShouldNotBeChecked(String menuPath) {
        this.windowKeywords.selectMainWindow();
        this.menuItemShouldNotBeChecked(menuPath);
    }

    @RobotKeyword(value="Searches for an checkbox menu item from the menu of the currently selected window and fails if it is not checked.\n\nExample:\n| Menu Item Should Be Checked | _Tools|My Checkbox_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void menuItemShouldBeChecked(String menuPath) {
        Assert.assertTrue("Menu item '" + menuPath + "' is not selected.", this.showMenuItem(menuPath).isSelected());
    }

    @RobotKeyword(value="Searches for an checkbox menu item from the menu of the currently selected window and fails if it is checked.\n\nExample:\n| Menu Item Should Not Be Checked | _Tools|My Checkbox_ |\n")
    @ArgumentNames(value={"menuPath"})
    public void menuItemShouldNotBeChecked(String menuPath) {
        Assert.assertFalse("Menu item '" + menuPath + "' is selected.", this.showMenuItem(menuPath).isSelected());
    }

    protected JCheckBoxMenuItemOperator showMenuItem(String path) {
        JMenuItemOperator menuItemOperator = super.showMenuItem(path);
        return new JCheckBoxMenuItemOperator((JCheckBoxMenuItem)menuItemOperator.getSource());
    }
}

